const testConfig = {
  datasource: 'pg96',
  query: 'SELECT * FROM events',
  target: 'my-index',
  strategy: 'REPLACE',
  staging_prefix: '',
  pk_field: 'id',
  mapping: {},
  pipeline: {
    description: 'Converts long to date and adds summary',
    processors: [
      {
        script: {
          source: 'ctx.date_formatted =  new Date(ctx.occurred)',
          lang: 'painless',
          params: {
            param_c: 10
          }
        }
      },
      {
        set: {
          field: 'summary',
          value: 'Happened in {{location}} at {{date_formatted}}'
        }
      }
    ]
  },
  transforms: [
    {
      input: [
        {
          source: 'summary'
        }
      ],
      output: 'summary',
      mapping: {
        type: 'text',
        fields: {
          keyword: {
            type: 'keyword'
          }
        }
      }
    },
    {
      input: [
        {
          source: 'id'
        }
      ],
      output: 'id',
      mapping: {
        type: 'long'
      }
    },
    {
      input: [
        {
          source: 'occurred'
        }
      ],
      output: 'occurred',
      mapping: {
        type: 'date'
      }
    },
    {
      input: [
        {
          source: 'value'
        }
      ],
      output: 'value',
      mapping: {
        type: 'long'
      }
    },
    {
      input: [
        {
          source: 'location'
        }
      ],
      output: 'location',
      mapping: {
        type: 'keyword'
      }
    }
  ],
  schedule: '0 15 10 ? * *',
  enable_scheduler: false,
  batch_size: null,
  description: '',
  removed_fields: [],
  virtual_index: '',
  id: 'New-Job-Configuration'
};

const expectedMergedConfig = {
  batch_size: '',
  description: '',
  datasource: 'pg96',
  virtual_index: '',
  pipelineMethod: 'elasticsearch',
  // eslint-disable-next-line max-len
  pipeline: '{\n  \"description\": \"Converts long to date and adds summary\",\n  \"processors\": [\n    {\n      \"script\": {\n        \"source\": \"ctx.date_formatted =  new Date(ctx.occurred)\",\n        \"lang\": \"painless\",\n        \"params\": {\n          \"param_c\": 10\n        }\n      }\n    },\n    {\n      \"set\": {\n        \"field\": \"summary\",\n        \"value\": \"Happened in {{location}} at {{date_formatted}}\"\n      }\n    }\n  ]\n}',
  pipelineInput: '',
  pipelineResult: '',
  query: 'SELECT * FROM events',
  target: 'my-index',
  strategy: 'REPLACE',
  staging_prefix: '',
  schedule: '0 15 10 ? * *',
  enable_scheduler: false,
  mapping: {
  },
  pk_field: 'id',
  removed_fields: [
  ],
  transforms: [
    {
      input: 'summary',
      transform: 'copy',
      mapping: '{\"type\":\"text\",\"fields\":{\"keyword\":{\"type\":\"keyword\"}}}',
      mappingObject: {
        type: 'text',
        fields: {
          keyword: {
            type: 'keyword'
          }
        }
      },
      mappingOption: '',
      output: 'summary'
    },
    {
      input: 'id',
      transform: 'copy',
      mapping: '{\"type\":\"long\"}',
      mappingObject: {
        type: 'long'
      },
      mappingOption: '',
      output: 'id'
    },
    {
      input: 'occurred',
      transform: 'copy',
      mapping: '{\"type\":\"date\"}',
      mappingObject: {
        type: 'date'
      },
      mappingOption: '',
      output: 'occurred'
    },
    {
      input: 'value',
      transform: 'copy',
      mapping: '{\"type\":\"long\"}',
      mappingObject: {
        type: 'long'
      },
      mappingOption: '',
      output: 'value'
    },
    {
      input: 'location',
      transform: 'copy',
      mapping: '{\"type\":\"keyword\"}',
      mappingObject: {
        type: 'keyword'
      },
      mappingOption: '',
      output: 'location'
    }
  ],
  es_credentials: {
    username: '',
    password: ''
  },
  ds_credentials: {
    username: '',
    password: ''
  }
};

const datasources = [
  {
    _id: 'pg96',
    _source: {}
  },
  {
    _id: 'petra-mysql',
    _source: {}
  }
];

const virtualIndices = [
  {
    _id: 'vritualpg',
    _source: {
      datasource: 'pg96'
    }
  },
  {
    _id: 'pharma-ae',
    _source: {
      datasource: 'petra-mysql'
    }
  }
];

export {
  testConfig,
  datasources,
  virtualIndices,
  expectedMergedConfig
};