import { resolve } from '../../utils';
import React from 'react';
import Header from '../header';
import {
  EuiHeaderLinks,
  EuiHeaderLink
} from '@elastic/eui';


export default class ConfigurationsHeader extends Header {

  renderActions() {
    const actions = [];
    if (this.props.displayNew) {
      actions.push((
        <EuiHeaderLink
          href={resolve('/configuration')}
          key="1"
        >
          New
        </EuiHeaderLink>
      ));
    }
    if (this.props.displaySave) {
      actions.push((
        <EuiHeaderLink
          onClick={e => this.props.onSaveClick(e)}
          key="2"
        >
          Save
        </EuiHeaderLink>
      ));
    }
    return (
      <EuiHeaderLinks>
        {actions}
      </EuiHeaderLinks>
    );
  }

}