import React from 'react';
import PropTypes from 'prop-types';

import {
  EuiBasicTable,
  EuiBadge,
  EuiFieldText,
  EuiFlexGroup,
  EuiFlexItem,
  EuiTextColor
} from '@elastic/eui';

const getBadge = function (color, text) {
  return (
    <EuiBadge color={color}>{text}</EuiBadge>
  );
};

const ConfigureRelations = props => {
  const COLUMNS = [
    {
      name: 'Node',
      field: 'nodeName'
    },
    {
      name: 'Search Name',
      field: 'savedSearch'
    },
    {
      name: 'Relation Label',
      render: (item) => {
        return (
          <EuiFieldText
            value={item.label}
            onChange={e => {
              item.label = e.target.value;
              props.onItemChange(item);
            }}
          />
        );
      }
    },
    {
      name: 'Inverse Relation Label',
      render: (item) => {
        return (
          <EuiFieldText
            value={item.inverseLabel}
            onChange={e => {
              item.inverseLabel = e.target.value;
              props.onItemChange(item);
            }}
          />
        );
      }
    },
    {
      name: 'Relation',
      render: ({ relations, nodeName, label, inverseLabel, color }) => {
        return (
          <div>
            {relations.map(({ startNode, endNode }) =>
              (
                <p key={`${startNode}-${endNode}`}>
                  {getBadge('default', startNode)}
                  <code>{label}&#8594;</code>
                  {getBadge(color, nodeName)}
                  <code>{label}&#8594;</code>
                  {getBadge('default', endNode)}
                  <br />
                  <br />
                  {getBadge('default', endNode)}
                  <code>{inverseLabel}&#8594;</code>
                  {getBadge(color, nodeName)}
                  <code>{inverseLabel}&#8594;</code>
                  {getBadge('default', startNode)}
                </p>
              )
            )}
          </div>
        );
      }
    }
  ];
  return (
    <EuiBasicTable
      items={props.relationEntitiesList}
      itemId="nodeName"
      columns={COLUMNS}
    />
  );
};

ConfigureRelations.propTypes = {
  relationEntitiesList: PropTypes.arrayOf(
    PropTypes.shape({
      color: PropTypes.string.isRequired,
      es: PropTypes.string.isRequired,
      icon: PropTypes.string.isRequired,
      jobId: PropTypes.string.isRequired,
      nodeName: PropTypes.string.isRequired,
      label: PropTypes.string.isRequired,
      savedSearch: PropTypes.string.isRequired,
      inverseLabel: PropTypes.string,
      relations: PropTypes.arrayOf(
        PropTypes.exact({
          startNode: PropTypes.string,
          endNode: PropTypes.string,
        })
      ).isRequired
    })
  ).isRequired,
  onItemChange: PropTypes.func.isRequired
};

export {
  ConfigureRelations
};