jest.mock('ui/chrome', () => ({
  getBasePath: () => ''
}), { virtual: true });

import React from 'react';
import { shallow } from 'enzyme';
import { Neo4jWizard } from './neo4j_wizard';

function getDefaultProps() {
  return {
    match: {
      params: {
        neo4jDatasource: 'local-neo4j'
      }
    },
    createNotifier: () => {},
    client: {},
    currentSection: '',
    sections: [
      {
        href: '',
        id: '',
        name: ''
      }
    ]
  };
}

describe('Neo4j Wizard', () => {
  it('renders', () => {
    const component = shallow(<Neo4jWizard {...getDefaultProps()}/>);
    expect(component).toMatchSnapshot();
  });
});