import React from 'react';
import {
  EuiFieldText,
  EuiSwitch
} from '@elastic/eui';
function scheduler(props) {
  return (
    <div>
      <EuiSwitch
        label="Enable Scheduler?"
        checked={props.configuration.enable_scheduler}
        onChange={e => props.onChange(e.target.checked, 'enable_scheduler')}
      />
      <EuiFieldText
        value={props.configuration.schedule}
        onChange={e => props.onChange(e.target.value, 'schedule')}
        disabled={!props.configuration.enable_scheduler}
      />
    </div>
  );
}

export default scheduler;