import React from 'react';
import PropTypes from 'prop-types';
import {
  EuiSpacer,
  EuiStepsHorizontal,
  EuiTitle
} from '@elastic/eui';

import Section from '../section';

class Wizard extends Section {
  constructor(props) {
    super(props);
  }

  goBack() {
    throw Error('goBack not implemented');
  }

  getTitle() {
    throw Error('getTitle not implemented');
  }

  /**
   * Return an Object of wizard steps with following properties:
   *   id (the key), isComplete, name, disabled
   */
  getSteps() {
    throw Error('getSteps not implemented');
  }

  goToStep() {
    throw Error('goToStep not implemented');
  }

  renderSteps() {
    const steps = this.getSteps();
    const wizardSteps = Object.keys(steps).map(stepKey => {
      const step = steps[stepKey];
      return {
        onClick: () => this.goToStep(step.id),
        isSelected: step.id === this.state.currentStep,
        isComplete: step.isComplete,
        title: step.name,
        disabled: step.disabled
      };
    });
    return (
      <EuiStepsHorizontal
        steps={wizardSteps}
      />);
  }

  renderCurrentStep() {
    throw Error('renderCurrentStep not implemented');
  }

  renderBack() {
    return (<a onClick={this.goBack}>../</a>);
  }

  renderSection() {
    return (
      <React.Fragment>
        <EuiTitle size="m">
          <h1>{this.renderBack()}{this.getTitle()}</h1>
        </EuiTitle>
        <EuiSpacer size="s" />
        {this.renderSteps()}
        <EuiSpacer size="s" />
        {this.renderCurrentStep()}
      </React.Fragment>
    );
  }
}

export {
  Wizard
};

Wizard.propTypes = {
};
