import React from 'react';
import { resolve } from '../../utils';

import {
  EuiCard,
  EuiIcon,
  EuiFlexGroup,
  EuiFlexItem,
  EuiPageBody,
  EuiPageContent,
  EuiPageContentBody,
  EuiPageContentHeader,
  EuiPageContentHeaderSection,
  EuiTitle
} from '@elastic/eui';

const cards = ['Reflection Jobs', 'Excel/CSV Import'];
const paths = ['/configurations', '/xlsx'];
const icons = ['indexSettings', 'editorTable'];
const descriptions = [
  'One time or scheduled mirroring of data from remote sources',
  'Import an Excel/CSV File'
];
const getDisabledReflectionCard = function (item, index) {
  return (
    <EuiFlexItem key={index}>
      <EuiCard
        data-test-subj={`${item}`}
        icon={<EuiIcon style={{ color: '#d9d9d9' }} size="xxl" type={icons[index]} />}
        title={`${item} (disabled)`}
        description={descriptions[index]}
      />
    </EuiFlexItem>
  );
};
const cardNodes = cards.map((item, index) => {
  return (
    <EuiFlexItem key={index}>
      <EuiCard
        data-test-subj={`${item}`}
        icon={<EuiIcon style={{ color: '#476b9a' }} size="xxl" type={icons[index]} />}
        title={`${item}`}
        description={descriptions[index]}
        onClick={() => window.location.href = resolve(paths[index])}
      />
    </EuiFlexItem>
  );
});

export default (props) => {
  const cardsToRender = cardNodes;
  if (props.turnOffDataReflection) {
    cardsToRender[0] = getDisabledReflectionCard(cards[0], 0);
  }
  document.title = 'Ingestion - Siren';
  return (
    <EuiPageBody style={{ backgroundColor: '#f5f5f5' }}>
      <EuiPageContent verticalPosition="center" horizontalPosition="center">
        <EuiPageContentHeader>
          <EuiPageContentHeaderSection>
            <EuiTitle>
              <h2>Please choose an option</h2>
            </EuiTitle>
          </EuiPageContentHeaderSection>
        </EuiPageContentHeader>
        <EuiPageContentBody>
          <EuiFlexGroup gutterSize="l">
            {cardsToRender}
          </EuiFlexGroup>
        </EuiPageContentBody>
      </EuiPageContent>
    </EuiPageBody>
  );
};