import React, { Component } from 'react';
import {
  EuiBasicTable,
  EuiAccordion,
  EuiSpacer,
  EuiCallOut
} from '@elastic/eui';

function FileErrors(props) {
  const items = props.errors || [];
  const columns = [{
    field: 'row',
    name: 'Row'
  }, {
    field: 'type',
    name: 'Error Type'
  }, {
    field: 'code',
    name: 'Error Code'
  }, {
    field: 'message',
    name: 'Error Message'
  }, {
    field: 'index',
    name: 'Index'
  }];
  if (items.length === 0) {
    return '';
  }
  return (
    <div>
      <EuiCallOut
        size="s"
        title="Encountered a few errors while parsing."
        color="warning"
        iconType="alert"
      />
      <EuiSpacer size="m" / >
      <EuiAccordion id="errortable" buttonContent="Show Errors">
        <div>
          <EuiSpacer size="m" />
          <EuiBasicTable
            items={items}
            columns={columns}
          />
          <EuiSpacer size="m" />
        </div>
      </EuiAccordion>
      <EuiSpacer size="m" />
    </div>
  );
}

export default FileErrors;