import React from 'react';
import { shallow } from 'enzyme';
import expect from 'expect.js';
import MultiValued from '../multiValued';

describe('ingest mapping_table', () => {
  describe('multivalued', () => {
    let item;
    const onToggle = () => {};
    const onChangeMapping = () => {};
    let multiValuedDOM;
    const getMultiValued = () => {
      if (!multiValuedDOM) {
        multiValuedDOM = shallow(<MultiValued
          item={item}
          onToggle={onToggle}
          onChangeMapping={onChangeMapping}
        />);
      }
      return multiValuedDOM;
    };

    beforeEach(() => {
      multiValuedDOM = null;
      item = {
        name: 'Test Item',
        sanitizedFieldName: 'Test_Item',
        delimited: '',
        multiValued: false
      };
    });

    it('input field doesn\'t render when multiValued not checked', () => {
      const dom = getMultiValued();
      expect(dom.find('EuiSwitch').length).to.be.equal(1);
      expect(dom.find('EuiFieldText').length).to.be.equal(0);
    });

    it('input field and check box renders when multiValued is checked', () => {
      item.multiValued = true;
      const dom = getMultiValued();
      expect(dom.find('EuiFieldText').length).to.be.equal(1);
      expect(dom.find('EuiCheckbox').length).to.be.equal(1);
    });

    it('delimiter renders', () => {
      item.multiValued = true;
      item.delimiter = '/';
      const dom = getMultiValued();
      expect(dom.find('EuiSwitch').props().checked).to.be.true;
      const textField = dom.find('EuiFieldText');
      expect(textField.length).to.be.equal(1);
      expect(textField.props().value).to.be.equal(item.delimiter);
      expect(dom.find('EuiCheckbox').length).to.be.equal(1);
    });

    it('JSON delimiter works', () => {
      item.multiValued = true;
      item.delimiter = 'JSON';
      const dom = getMultiValued();
      expect(dom.find('EuiSwitch').props().checked).to.be.true;
      const textField = dom.find('EuiFieldText');
      expect(textField.length).to.be.equal(1);
      expect(textField.props().value).to.be.equal(item.delimiter);
      const checkBox = dom.find('EuiCheckbox');
      expect(checkBox.length).to.be.equal(1);
      expect(checkBox.props().checked).to.be.true;
    });
  });
});
