import React, { Component } from 'react';
import {
  EuiBasicTable,
} from '@elastic/eui';
import update from 'immutability-helper';
import TypeSelector from './typeSelector';
import {
  getUpdatedMappingTableState
} from '../../services/services.js';

class MappingTable extends Component {

  constructor(props) {
    super(props);

    this.state = {
      items: this.filterItems(this.props.items, this.props.removedItems)
    };

    const self = this;
    const cleanSample = (sample) => {
      if (sample || sample === false) {
        if (typeof sample === 'object' || typeof sample === 'boolean') {
          sample = sample.toString();
        }
        if (sample.length > 250) {
          sample = `${sample.substr(0, 250)}...`;
        }
      }
      return sample;
    };
    const removeAction = [{
      name: 'Remove Field',
      description: 'Remove this field',
      icon: 'trash',
      color: 'danger',
      type: 'icon',
      onClick: this.props.onFieldRemoval
    }];
    this.columns = [{
      field: 'name',
      name: 'Fields',
      render: (name, item) => name || item.sanitizedFieldName
    }, {
      name: 'Samples',
      render: (item) => {
        const fieldName = item.sanitizedFieldName;
        const columns = [{
          field: fieldName,
          name: `${item.name} Samples`,
          render: cleanSample
        }];
        return (
          <EuiBasicTable
            items={self.props.examples}
            columns={columns}
          />);
      }
    }, {
      name: 'Type',
      render: (item) => {
        return (
          <TypeSelector
            item={item}
            onTokenize={this.onTokenize}
            triggerUpdate={this.updateItem}
            hideMultiValued={this.props.hideMultiValued}
          />
        );
      }
    }, {
      name: 'Remove Column',
      actions: removeAction
    }];
    this.onTokenize = this.onTokenize.bind(this);
    this.filterItems = this.filterItems.bind(this);
    this.updateItem = this.updateItem.bind(this);
  }

  filterItems(items, removed) {
    let finalItems = items;
    if (removed.length > 0) {
      finalItems = finalItems.filter(ele =>
        removed.findIndex(rem => {
          return rem.label === ele.sanitizedFieldName;
        }) < 0
      );
    }
    return finalItems;
  }

  componentWillReceiveProps(nextProps) {
    this.setState({
      items: this.filterItems(nextProps.items, nextProps.removedItems)
    });
  }

  updateItem(item) {
    const fieldIndex = this.state.items.findIndex(
      (ele) => ele.sanitizedFieldName === item.sanitizedFieldName
    );
    this.setState({
      items: update(this.state.items, {
        [fieldIndex]: { $set: item }
      })
    });
  }

  onTokenize(e) {
    const { checked } = e.target;
    const sanitizedFieldName = e.target.getAttribute('sanitizedfieldname');
    const items = getUpdatedMappingTableState(this.state.items);
    const fieldIndex = items.findIndex(
      (ele) => ele.sanitizedFieldName === sanitizedFieldName
    );
    let advJson = items[fieldIndex].advJson;
    if (checked === false) {
      try {
        if (advJson) {
          if (typeof advJson === 'string') {
            advJson = JSON.parse(advJson);
          }
          delete advJson.fielddata;
          delete advJson.analyzer;
        }
      } catch (e) {
        //Do Nothing
      }
    }
    this.setState({
      items: update(items, { [fieldIndex]: {
        tokenize: { $set: checked },
        advJson: { $set: advJson } }
      })
    });
  }

  render() {
    return (
      <div>
        <EuiBasicTable
          items={this.state.items}
          itemId="sanitizedFieldName"
          key="sanitizedFieldName"
          columns={this.columns}
          hasActions={false}
        />
      </div>
    );
  }
}

export default MappingTable;
