import React from 'react';
import { shallow, mount } from 'enzyme';
import TypeSelector from './typeSelector';

describe('TypeSelector', () => {
  let itemProps;

  const getShallow = props => {
    return shallow(<TypeSelector {...props} />);
  };

  const getMount = props => {
    return shallow(<TypeSelector {...props} />);
  };

  const findMultiValued = component => {
    return component.find('MultiValued');
  };

  beforeEach(() => {
    itemProps = {
      advJson: '{ "fielddata": true }',
      useAdv: true,
      type: 'text',
      multiValued: true,
      delimiter: '|',
      sanitizedFieldName: 'description'
    };
  });

  it('renders', () => {
    const shallowComponent = getShallow({ item: itemProps });
    expect(shallowComponent).toMatchSnapshot();
  });

  describe('mounts', () => {
    it('shows multiValued by default', () => {
      const mountedComponent = getMount({ item: itemProps });
      const multivalued = findMultiValued(mountedComponent);
      expect(multivalued.length).toBe(1);
    });

    it('hideMultiValued works', () => {
      const mountedComponent = getMount({ hideMultiValued: true, item: itemProps });
      const multivalued = findMultiValued(mountedComponent);
      expect(multivalued.length).toBe(0);
    });
  });

});