import React, { Component, Fragment } from 'react';
import {
  EuiCallOut,
  EuiSpacer,
  EuiButtonEmpty,
  EuiForm,
  EuiFormRow,
  EuiFlexItem,
  EuiFlexGroup
} from '@elastic/eui';

import { displayStats } from './ui_helpers';
import ErrorTable from './errorTable';

class StepThree extends Component {
  constructor(props) {
    super(props);
    this.newIndexPatternUrl = './kibana#/management/siren/datamodel/new/search_entity';
    this.newIndexLink = this.newIndexLink.bind(this);
  }

  handleClick = () => {
    window.location.reload();
  }

  newIndexLink() {
    return (
      <p>
        To use this data, you may want to&nbsp;
        <a href={`${this.newIndexPatternUrl}/${this.props.state.indexName}`}>
          <b>Create an Index Pattern Search</b>
        </a>
        &nbsp;for this Index.
      </p>);
  }

  render() {
    const docsIndexed = this.props.state.nbDocument - this.props.state.errorsDuringIndexing.length;
    let color;
    let iconType;
    let title;
    let showNewIndexLink = false;
    if (docsIndexed === 0) {
      color = 'danger';
      iconType = 'cross';
      title = 'Your file was Not imported!';
    } else {
      showNewIndexLink = true;
      const allImported = docsIndexed === this.props.state.nbDocument;
      color = allImported ? 'success' : 'warning';
      iconType = allImported ? 'check' : 'alert';
      title = allImported ? 'Your file has been imported!' :
        'Your file has been partially imported!';
    }
    return (
      <Fragment>
        <EuiForm>
          <EuiFormRow>
            <EuiCallOut
              title={title}
              color={color}
              iconType={iconType}
            >
              <EuiSpacer size="s"/>
              <p>{docsIndexed} out of
                &nbsp;{this.props.state.nbDocument} document(s) have been imported into <b>{this.props.state.indexName}</b>.
              </p>
              {showNewIndexLink ? this.newIndexLink() : null}
              <p><b>File name</b> : {this.props.state.fileName}</p>
              <p><b>Sheet name</b> : {this.props.state.sheetName}</p>
              {displayStats(this.props.state.jobStats, true)}
            </EuiCallOut>
          </EuiFormRow>
          <EuiFormRow fullWidth={true}>
            <ErrorTable errors={this.props.state.errorsDuringIndexing} />
          </EuiFormRow>
          <EuiFormRow>
            <EuiFlexGroup gutterSize="s" alignItems="center">
              <EuiFlexItem grow={false}>
                <EuiButtonEmpty onClick={this.handleClick} size="s" iconType="arrowRight">
                  Import a new file
                </EuiButtonEmpty>
              </EuiFlexItem>
            </EuiFlexGroup>
          </EuiFormRow>
        </EuiForm>
      </Fragment>
    );
  }
}

export default StepThree;