const SELECTORS = {
  ERROR_TYPE: '[data-header="Error Type"]',
  ERROR_COUNT: '[data-header="Error Count"]'
};

const renderTests = [
  {
    description: 'When no errors are passed',
    props: {},
    expected: component => {
      expect(component.length).toBe(1);
    }
  },
  {
    description: 'When error is passed',
    props: {
      errors: [
        {
          index: {
            _index: 'basiccompanydataasonefile',
            _type: 'doc',
            _id: 'e8ykVGoBEkH4rbdEZazz',
            status: 400,
            error: {
              type: 'mapper_parsing_exception',
              reason: 'failed to parse field [_CompanyNumber] of type [long]',
              caused_by: {
                type: 'illegal_argument_exception',
                reason: 'For input string: "SC606050"'
              }
            }
          }
        },
        {
          index: {
            _index: 'basiccompanydataasonefile',
            _type: 'doc',
            _id: 'e8ykVGoBEkH4rbdEZazz',
            status: 400,
            error: {
              type: 'some_other_exception',
              reason: 'failed to parse field [Employee_ID] of type [long]',
              caused_by: {
                type: 'illegal_argument_exception',
                reason: 'For input string: "SC606050"'
              }
            }
          }
        }
      ],
      initialIsOpen: true
    },
    expected: component => {
      expect(component.length).toBe(1);
      expect(component.find(SELECTORS.ERROR_TYPE).length).toBe(2);
      expect(component.find(SELECTORS.ERROR_TYPE).at(0).getDOMNode().textContent).toBe('mapper_parsing_exception');
      expect(component.find(SELECTORS.ERROR_COUNT).at(0).getDOMNode().textContent).toBe('1');
      expect(component.find(SELECTORS.ERROR_TYPE).at(1).getDOMNode().textContent).toBe('some_other_exception');
      expect(component.find(SELECTORS.ERROR_COUNT).at(1).getDOMNode().textContent).toBe('1');
    }
  }
];

export {
  renderTests
};