import React from 'react';
import {
  secondsToHms
} from '../services/helper.js';
function displayStats(stats, resultsPage) {
  stats = stats || {};
  return (
    <div>
      { resultsPage ?
        '' :
        <p><b>Documents Processed:</b> {stats.documentsIngested}<b>{stats.totalDocuments ? '/' + stats.totalDocuments : ''}</b></p>
      }
      <p><b>Ingestion Rate:</b> {stats.speed} Docs/Sec</p>
      { stats.totalFileSize && !resultsPage ?
        <p><b>File Progress:</b> {stats.cursor}<b>/</b>{stats.totalFileSize} Bytes</p> : ''
      }
      { resultsPage ?
        <p><b>Time Taken:</b> {secondsToHms(stats.secondsElapsed)}</p> :
        <p><b>ETA:</b> {stats.eta}</p>
      }
    </div>
  );
}

export default {
  displayStats
};