const testDoc = {
  Record_ID: 560073,
  Record_State: 'Closed',
  Project: 'Corrective/Preventive Action',
  Due_Date: '19/12/2016',
  CPA_Approved_On: '19/12/2016 12:51',
  'J&J_Site_Name': 'Poland_Warsaw_Ilzecka',
  Title: 'Migrated Record EC - EC for CAPA for RCA for OPR2016Q10263 RDQA 100854',
  'J&J_Functional_Area_1': 'LOC - EMEA',
  'J&J_Functional_Area_2': 'N/A',
  'J&J_Business_Unit': 'Local Operating Company',
  'J&J_Region': 'EMEA',
  Quality_Leader: 'Motoma, Rachael',
  Date_Created: '19/12/2016 09:32',
  GxP: 'PV',
  'J&J_Segment': 'Consumer - RnD',
  Additional_Segments_Affected: 'Consumer',
  Description: 431325,
  Original_Due_Date: '19/12/2016 00:00',
  'Extension_Status_-_Due_Date': 'No Active Extension Requests',
  'No._of_Extensions_Completed': 0,
  Parent_ID: 558794,
  CPA_Plan_Approved_On: '19/12/2016 09:55',
  Action_Execution_Summary: 'Migrated Record',
  Action_Plan: 'Migrated Record',
  Assigned_To: 'SZYMCHEL, AGNIESZKA',
  CPA_Approved_By: 'BLACKWAY, CHERYL',
  'Action_Type?': 'Corrective Action',
  Effectiveness_Check_Required: 'Yes',
  Effectiveness_Check_Due_Date: '2017-11-06T18:30:00.000Z',
  EC_Approved_On: '2017-05-07T09:14:00.000Z',
  EC_Approved_By: 'Motoma, Rachael',
  'No._of_Extensions_Completed_2': 0,
  'Extension_Status_-_EC_Due_Date': 'No Active Extension Requests',
  Original_EC_Due_Date: '2017-11-06T18:30:00.000Z',
  'Effective_CPA?': 'Yes',
  'Eff._Check_Rationale/Plan': 'EC1: \tAction: Check for alignment of local and global procedural documents.',
  'Related_System_Record(s)': 453301,
  'Root_Cause(s)': 'Migrated Record'
};

const fields = ['Record_ID', 'Record ID', 'Does Not Exist'];

const mappingInfo = [
  {
    name: 'Record ID',
    type: 'float',
    sanitizedFieldName: 'Record_ID',
    multiValued: false,
    delimiter: null,
    advJson: null,
    useAdv: false
  },
  {
    name: 'Record State',
    type: 'keyword',
    sanitizedFieldName: 'Record_State',
    multiValued: false,
    delimiter: null,
    advJson: null,
    useAdv: false
  },
  {
    name: 'Project',
    type: 'keyword',
    sanitizedFieldName: 'Project',
    multiValued: true,
    delimiter: '/',
    advJson: null,
    useAdv: false
  },
  {
    name: 'Due Date',
    type: 'keyword',
    sanitizedFieldName: 'Due_Date',
    multiValued: false,
    delimiter: null,
    advJson: null,
    useAdv: false
  },
  {
    name: 'CPA Approved On',
    type: 'keyword',
    sanitizedFieldName: 'CPA_Approved_On',
    multiValued: false,
    delimiter: null,
    advJson: null,
    useAdv: false
  }
];

const indexMappingJson1 = {
  'textField': {
    'type': 'text'
  },
  'analyzedTextField': {
    'type': 'text',
    'useAdv': true,
    'advJson': {
      'fielddata': true,
      'analyzer': 'english'
    }
  },
  'firstLevel.secondLevel.lastLevelAnalyzedTextField': {
    'type': 'text',
    'useAdv': true,
    'advJson': {
      'fielddata': true,
      'analyzer': 'english'
    }
  },
  'firstLevel.secondLevel.lastLevelTextField': {
    'type': 'text'
  },
  'firstLevel.secondLevel.thirdLevel.lastLevelAnalyzedTextField': {
    'type': 'text',
    'useAdv': true,
    'advJson': {
      'fielddata': true,
      'analyzer': 'english'
    }
  },
  'firstLevel.secondLevel.thirdLevel.lastLevelTextField': {
    'type': 'text'
  }
};

const retrieveMappingTestData = [
  {
    indexName: '.my-index.name',
    responseFromES: {
      '.my-index.name': {
        mappings: {
          doc: {
            properties: {
              textField: {
                type: 'text'
              },
              analyzedTextField: {
                type: 'text',
                fielddata: true,
                analyzer: 'english'
              },
              firstLevel: {
                type: 'nested',
                properties: {
                  secondLevel: {
                    type: 'nested',
                    properties: {
                      lastLevelAnalyzedTextField: {
                        type: 'text',
                        fielddata: true,
                        analyzer: 'english'
                      },
                      lastLevelTextField: {
                        type: 'text'
                      },
                      thirdLevel: {
                        type: 'nested',
                        properties: {
                          lastLevelAnalyzedTextField: {
                            type: 'text',
                            fielddata: true,
                            analyzer: 'english'
                          },
                          lastLevelTextField: {
                            type: 'text'
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    },
    expectedReturn: indexMappingJson1
  }
];

const mergeFromIndexMappingTestData = [
  {
    mappingInfo: [
      {
        sanitizedFieldName: 'textField',
        type: 'long',
        multiValued: true,
        delimiter: ',',
        tokenize: true,
        useAdv: false,
        advJson: null
      }, {
        sanitizedFieldName: 'analyzedTextField',
        type: 'keyword',
        multiValued: false,
        delimiter: '',
        tokenize: false,
        useAdv: false,
        advJson: null
      }, {
        sanitizedFieldName: 'someField',
        type: 'text',
        multiValued: false,
        delimiter: '',
        tokenize: true,
        useAdv: true,
        advJson: {
          fielddata: true,
          analyzer: 'english'
        }
      }
    ],
    indexMappingJson: indexMappingJson1,
    expectedReturn: [
      {
        sanitizedFieldName: 'textField',
        type: 'text',
        multiValued: true,
        delimiter: ',',
        tokenize: true,
        useAdv: false,
        advJson: null
      }, {
        sanitizedFieldName: 'analyzedTextField',
        multiValued: false,
        delimiter: '',
        tokenize: false,
        'type': 'text',
        'useAdv': true,
        'advJson': {
          'fielddata': true,
          'analyzer': 'english'
        }
      }, {
        sanitizedFieldName: 'someField',
        type: 'text',
        multiValued: false,
        delimiter: '',
        tokenize: true,
        useAdv: true,
        advJson: {
          fielddata: true,
          analyzer: 'english'
        }
      }
    ]
  }
];

const splitByComma = {
  multiValued: true,
  delimiter: ',',
  sanitizedFieldName: 'multiValueField'
};
const jsonParsing = {
  multiValued: true,
  delimiter: 'JSON',
  sanitizedFieldName: 'jsonField'
};
const createBulkTestData = [
  {
    json: [
      {
        dummyData: 'This is some data',
        multiValueField: 'Red, Green, Blue',
        jsonField: '{"somedata":"somedata"}',
        name: 'xyz'
      },
      {
        dummyData: 'This is some data',
        multiValueField: ' 21331.4, 2323.21 , true ',
        jsonField: 'malformedJson',
        name: 233.45
      },
      {
        dummyData: 'This is some data',
        multiValueField: ' This is Red , Green , 22 44',
        jsonField: '[{"arraydata":"arraydata"}]',
        name: '{name}-value'
      }
    ],
    mappingItems: {
      all: [
        splitByComma,
        jsonParsing
      ],
      splitByComma: [splitByComma],
      jsonParsing: [jsonParsing]
    },
    bulkSize: 2,
    username: 'testUser',
    kbnCustomId: '{name}-id',
    expected: {
      customIds: ['xyz-id', '233.45-id', '{name}-value-id'],
      splitFieldByComma: [
        [
          'Red',
          'Green',
          'Blue'
        ],
        [
          '21331.4',
          '2323.21',
          'true'
        ],
        [
          'This is Red',
          'Green',
          '22 44'
        ]
      ],
      jsonParsedField: [
        {
          somedata: 'somedata'
        },
        'malformedJson',
        [
          {
            arraydata: 'arraydata'
          }
        ]
      ],
      bulkRequestLength: 2,
      bulkPackageLength: [4, 2],
      withoutCustomSettings: [
        [
          {
            index: {}
          },
          {
            '@timestamp': new Date(1548959400000),
            _sirenImportUser: undefined,
            dummyData: 'This is some data',
            multiValueField: 'Red, Green, Blue',
            jsonField: '{"somedata":"somedata"}',
            name: 'xyz'
          },
          {
            index: {}
          },
          {
            '@timestamp': new Date(1548959400000),
            _sirenImportUser: undefined,
            dummyData: 'This is some data',
            multiValueField: ' 21331.4, 2323.21 , true ',
            jsonField: 'malformedJson',
            name: 233.45
          },
        ],
        [
          {
            index: {}
          },
          {
            '@timestamp': new Date(1548959400000),
            _sirenImportUser: undefined,
            dummyData: 'This is some data',
            multiValueField: ' This is Red , Green , 22 44',
            jsonField: '[{"arraydata":"arraydata"}]',
            name: '{name}-value'
          }
        ]
      ],
      everythingWorks: [
        [
          {
            index: {
              _id: 'xyz-id'
            }
          },
          {
            '@timestamp': new Date(1548959400000),
            _sirenImportUser: 'testUser',
            dummyData: 'This is some data',
            multiValueField: [
              'Red',
              'Green',
              'Blue'
            ],
            jsonField: {
              somedata: 'somedata'
            },
            name: 'xyz'
          },
          {
            index: {
              _id: '233.45-id'
            }
          },
          {
            '@timestamp': new Date(1548959400000),
            _sirenImportUser: 'testUser',
            dummyData: 'This is some data',
            multiValueField: [
              '21331.4',
              '2323.21',
              'true'
            ],
            jsonField: 'malformedJson',
            name: 233.45
          },
        ],
        [
          {
            index: {
              _id: '{name}-value-id'
            }
          },
          {
            '@timestamp': new Date(1548959400000),
            _sirenImportUser: 'testUser',
            dummyData: 'This is some data',
            multiValueField: [
              'This is Red',
              'Green',
              '22 44'
            ],
            jsonField: [
              {
                arraydata: 'arraydata'
              }
            ],
            name: '{name}-value'
          }
        ]
      ]
    }
  }
];

const createMappingTestData = [
  {
    items: [
      {
        "name": "Record ID",
        "type": "float",
        "sanitizedFieldName": "Record_ID",
        "delimiter": null,
        "tokenize": false,
        "useAdv": false,
        "advJson": null,
        "multiValued": false
      },
      {
        "name": "J&J Site Name",
        "type": "keyword",
        "sanitizedFieldName": "J&J_Site_Name",
        "delimiter": null,
        "tokenize": null,
        "useAdv": false,
        "advJson": null,
        "multiValued": false
      },
      {
        "name": "Title",
        "type": "text",
        "sanitizedFieldName": "Title",
        "delimiter": null,
        "tokenize": true,
        "useAdv": true,
        "advJson": "{\n  \"fielddata\": true,\n  \"analyzer\": \"english\"\n}",
        "multiValued": false
      },
      {
        "name": "J&J Functional Area 1",
        "type": "keyword",
        "sanitizedFieldName": "J&J_Functional_Area_1",
        "delimiter": null,
        "tokenize": null,
        "useAdv": false,
        "advJson": null,
        "multiValued": false
      },
      {
        "name": "GxP",
        "type": "keyword",
        "sanitizedFieldName": "GxP",
        "delimiter": null,
        "tokenize": false,
        "useAdv": false,
        "advJson": null
      },
      {
        "name": "Correction Plan Approved On",
        "type": "",
        "sanitizedFieldName": "Correction_Plan_Approved_On",
        "delimiter": null,
        "tokenize": false,
        "useAdv": false,
        "advJson": null,
        "multiValued": false
      }
    ],
    euiSelect: [
      {
        "value": "dontpick"
      },
      {
        "value": "dontpick"
      },
      {
        "value": "dontpick"
      },
      {
        "value": "dontpick"
      },
      {
        "value": "dontpick"
      },
      {
        "value": "keyword"
      }
    ],
    removedFields: [
      {
        "label": "GxP"
      },
      {
        "label": "J&J_Functional_Area_1"
      },
      {
        "label": "J&J_Site_Name"
      }
    ],
    expected: {
      properties: {
        "Record_ID": {
          "type": "float"
        },
        "Title": {
          "type": "text",
          "fielddata": true,
          "analyzer": "english"
        },
        "Correction_Plan_Approved_On": {
          "type": "keyword"
        }
      }
    }
  }
];

export {
  testDoc,
  fields,
  mappingInfo,
  retrieveMappingTestData,
  mergeFromIndexMappingTestData,
  createBulkTestData,
  createMappingTestData
};