import {
  getDelayedTrigger,
  secondsToHms
} from '../helper';

import expect from 'expect.js';
import sinon from 'sinon';

describe('ingest helper', () => {
  const delayedTrigger = getDelayedTrigger();
  it('getDelayedTrigger', (done) => {
    const method = sinon.mock();
    const parameter = {
      param: 'value'
    };
    for (let i = 1; i <= 3; i++) {
      setTimeout(() => delayedTrigger(method, 10, parameter), 5 * i);
    }
    setTimeout(() => {
      expect(method.callCount).to.equal(1);
      const args = method.getCall(0).args;
      expect(args[0]).to.eql(parameter);
      expect(args.length).to.equal(1);
      done();
    }, 100);
  });

  it('secondsToHms works', () => {
    const valueArray = [
      null,
      undefined,
      '3600.245',
      '-3600.009',
      '+3600.111109',
      3689.424224,
      -3689.24500009
    ];
    const resultArray = [
      '00:00:00.000',
      '00:00:00.000',
      '01:00:00.245',
      '01:00:00.009',
      '01:00:00.111',
      '01:01:29.424',
      '01:01:29.245'
    ];
    valueArray.forEach((value, index) => expect(secondsToHms(value)).to.equal(resultArray[index]));
  });
});