function getDelayedTrigger() {
  return (function () {
    let triggerTimer = 0;
    return function (callback, delay, parameter) {
      clearTimeout(triggerTimer);
      triggerTimer = setTimeout(() => callback(parameter), delay);
    };
  }());
}

function secondsToHms(d) {
  d = Math.abs(Number(d || 0));

  const h = Math.floor(d / 3600);
  const m = Math.floor(d % 3600 / 60);
  const s = (d % 3600 % 60).toFixed(3);

  return ('0' + h).slice(-2) + ':' + ('0' + m).slice(-2) + ':' + ('0' + s).slice(-6);
}
export { getDelayedTrigger, secondsToHms };