import { getESType } from './mapping_helpers';

describe('mappinghelpers', () => {
  describe('getESType', () => {
    [
      { test: 'text', expected: 'text' },
      { test: 'text_keyword', expected: 'text' },
      { test: 'keyword', expected: 'keyword' },
      { test: 'integer', expected: 'integer' },
      { test: 'short', expected: 'short' },
      { test: 'long', expected: 'long' },
      { test: 'double', expected: 'double' },
      { test: 'float', expected: 'float' },
      { test: 'date', expected: 'date' },
      { test: 'boolean', expected: 'boolean' },
      { test: 'byte', expected: 'byte' },
      { test: 'binary', expected: 'binary' },
      { test: 'ip', expected: 'ip' },
      { test: 'geo_point', expected: 'geo_point' },
      { test: 'geo_shape', expected: 'geo_shape' },
    ].forEach(ele => {
      it(`resolves ${ele.test}`, () => {
        expect(getESType(ele.test)).toBe(ele.expected);
      });
    });
  });
});