import React from 'react';
import {
  EuiToolTip,
  EuiFlexItem
} from '@elastic/eui';
function tooltipFlexItem(tooltipText, placeholder) {
  return (
    <EuiFlexItem grow={false}>
      <EuiToolTip
        position="right"
        content={tooltipText || 'Here is some tooltip text'}
      >
        <label className="helptext euiFormLabel euiFormLabel-isFocused">{placeholder || 'Help?'}</label>
      </EuiToolTip>
    </EuiFlexItem>
  );
}

function tooltipWrapComponent(component, tooltipText, position, delay) {
  return (
    <EuiToolTip
      content={tooltipText || 'Here is some tooltip text'}
      position={position || 'right'}
      delay={delay || 'regular'}
    >
      {component}
    </EuiToolTip>
  );
}

export { tooltipFlexItem, tooltipWrapComponent };