import React from 'react';
import { Redirect, Route, Switch } from 'react-router-dom';
import { EuiIcon } from '@elastic/eui';
import Client from './client';
import Configurations from './sections/configurations/configurations';
import ConfigurationForm from './sections/configurations/configuration_form';
import { Excel } from './sections/xlsx';
import Home from './sections/home';
import { Neo4jWizard } from './sections/configurations/neo4j_wizard';
import { resolve } from './utils';
const DATA_REFLECTION = 'MODULE_DATASOURCE_REFLECTION';

export default class Ui extends React.Component {

  constructor(props) {
    super(props);
    this.client = new Client(props.chrome.getBasePath(), props.httpClient, props.federateResolver);
    this.dataReflectionAvailable = props.federateResolver.isAvailable(DATA_REFLECTION);
    this.sections = [{
      href: resolve('/home'),
      id: 'home',
      name: (<EuiIcon type="apps" />)
    },
    ...this.dataReflectionAvailable && [{
      href: resolve('/configurations'),
      id: 'configurations',
      name: 'Datasource reflection jobs'
    }], {
      href: resolve('/xlsx'),
      id: 'xlsx',
      name: 'Excel/CSV Import'
    }];
  }

  dataReflectionRoutes() {
    if (this.dataReflectionAvailable) {
      return (
        <React.Fragment>
          <Route
            path="/configurations"
            render={
              props => {
                return (
                  <Configurations
                    {...props}
                    client={this.client}
                    createNotifier={this.props.createNotifier}
                    sections={this.sections}
                    currentSection="configurations"
                  />
                );
              }
            }
          />
          <Route
            path="/configuration/:id?"
            render={
              props => {
                return (
                  <ConfigurationForm
                    {...props}
                    client={this.client}
                    createNotifier={this.props.createNotifier}
                    sections={this.sections}
                    jdbcDatasources={this.props.jdbcDatasources}
                    currentSection="configurations"
                  />
                );
              }
            }
          />
          <Route
            path="/neo4j-wizard/:neo4jDatasource/:jobId?"
            render={
              props => {
                return (
                  <Neo4jWizard
                    {...props}
                    client={this.client}
                    chrome={this.props.chrome}
                    createNotifier={this.props.createNotifier}
                    sections={this.sections}
                    currentSection="configurations"
                  />
                );
              }
            }
          />
        </React.Fragment>
      );
    }
    return '';
  }

  render() {
    return (
      <Switch>
        <Route
          path="/home"
          render={() => <Home turnOffDataReflection={!this.dataReflectionAvailable}/>}
        />
        <Route
          path="/xlsx"
          render={
            () => {
              return (
                <Excel
                  sections={this.sections}
                  currentSection="xlsx"
                  injector={this.props.injector}
                />
              );
            }
          }
        />
        {this.dataReflectionRoutes()}
        <Redirect path="/" to="/home" />
      </Switch>
    );
  }

}