import neo4jAPIs from './neo4j';

const registerV1APIs = function (server, dataCluster, apiPath) {
  const BASE_PATH = `${apiPath}v1/`;
  const adminCluster = server.plugins.elasticsearch.getCluster('admin');

  neo4jAPIs(server, dataCluster, BASE_PATH);

  // Delete job logs
  server.route({
    path: `${BASE_PATH}clearJobLogs/{jobId}`,
    method: 'DELETE',
    handler: function (req, reply) {
      const jobId = req.params.jobId;
      adminCluster.callWithRequest(req, 'deleteByQuery', {
        ignore_unavailable: true,
        refresh: 'wait_for',
        conflicts: 'proceed',
        index: '.siren-federate-joblogs',
        body: {
          query: {
            term: {
              'ingestion.id.keyword': jobId
            }
          }
        }
      }).then(reply).catch(reply);
    }
  });
};

export {
  registerV1APIs
};