const Path = require('path');
module.exports = (server, hostPath) => {
  server.register(require('inert'), (err) => {
    if (err) {
      throw err;
    }
    const inertOptions = { confine: false };
    server.route({
      method: 'GET',
      path: hostPath + 'worker.js',
      handler: (request, reply) => {
        reply.file(Path.join(__dirname, 'hosted', 'worker.js'), inertOptions);
      }
    });

    server.route({
      method: 'GET',
      path: hostPath + 'xlsx.full.min.js',
      handler: (request, reply) => {
        reply.file(Path.join(__dirname, '../node_modules/xlsx/dist/xlsx.full.min.js'), inertOptions);
      }
    });

    server.route({
      method: 'GET',
      path: hostPath + 'papaparse.min.js',
      handler: (request, reply) => {
        reply.file(Path.join(__dirname, '../node_modules/papaparse/papaparse.min.js'), inertOptions);
      }
    });
  });
};
