
import visHtml from 'plugins/parallel_lines_chart_vis/parallel_vis.html';
import columnsHtml from 'plugins/parallel_lines_chart_vis/parallel_vis_columns.html';
import paramsHtml from 'plugins/parallel_lines_chart_vis/parallel_vis_params.html';

import 'plugins/parallel_lines_chart_vis/parallel_vis_controller';

import { VisVisTypeProvider } from 'ui/vis/vis_type';
import { TemplateVisTypeProvider } from 'ui/template_vis_type/template_vis_type';
import { VisSchemasProvider } from 'ui/vis/schemas';
import { VisTypesRegistryProvider } from 'ui/registry/vis_types';

import image from 'plugins/parallel_lines_chart_vis/parallel.svg';


// Provider

function ParallelVisTypeProvider(Private) {
  const VisType = Private(VisVisTypeProvider);
  const TemplateVisType = Private(TemplateVisTypeProvider);
  const Schemas = Private(VisSchemasProvider);

  return new TemplateVisType({
    name: 'parallel_lines_chart_vis',
    title: 'Parallel Lines Chart',
    image,
    isBeta: true,
    category: VisType.CATEGORY.CHARTS,
    dashboard360Compatible: true,
    description:
      'Arranges several metrics on parallel columns. Most useful on number-heavy datasets.',
    template: visHtml,
    params: {
      defaults: {
        colors: {
          low: 'rgba(120,120,250,0.5)',
          high: 'rgba(260,50,50,0.9)',
          highlight: 'orange',
          tip: 'orange',
          order: 'asc'
        },
        showFilteredOutRecords: true,
        useCanvas: true,
        ticksDistance: 30,
        bigSpPointsRadius: 3,
        columns: []
      },
      editor: true,
      optionTabs: [{
        name: 'advanced',
        title: 'Columns',
        editor: columnsHtml
      }, {
        name: 'options',
        title: 'Options',
        editor: paramsHtml
      }]
    },
    schemas: new Schemas([{
      group: 'metrics',
      name: 'metric',
      title: 'Metric Line Column',
      min: 0,
      aggFilter: ['count', 'avg', 'sum', 'min', 'max', 'cardinality', 'top_hits']
    }, {
      group: 'buckets',
      name: 'segment',
      title: 'Aggregating Line Column',
      aggFilter: [
        'date_histogram', 'histogram', 'significant_terms', 'terms',
        'range', 'date_range'//, 'ip_range'               // tricky...
      ],
      min: 0,
      max: Infinity
    }]),
    requiresSearch: true
  });
}

VisTypesRegistryProvider.register(ParallelVisTypeProvider);

// export the provider so that the visType can be required with Private()
export default ParallelVisTypeProvider;
