import $ from 'jquery';
import moment from 'moment';
import ngMock from 'ng_mock';
import expect from 'expect.js';
import { stubbedLogstashIndexPatternService } from 'fixtures/stubbed_logstash_index_pattern';
import searchResponseFixtureProvider from './fixtures/search_response';

describe('controller', function () {
  let $scope;
  let $el;
  let elastic;

  beforeEach(ngMock.module('kibana'));

  function init(options) {
    ngMock.inject(function ($rootScope, $controller, Private, $compile) {
      $el = $('<div>')
       .attr('class', 'siren_scatterplot_vis')
       .appendTo('body');
      $scope = $rootScope.$new();
      $scope.vis = {
        indexPattern: options.indexPattern || Private(stubbedLogstashIndexPatternService),
        params: options.params
      };
      elastic = {
        search: function (options) {
          return new Promise(function (resolve, reject) {
            resolve(searchResponseFixtureProvider());
          });
        }
      };
      $controller('ScatterPlotVisController', {
        $scope: $scope,
        $element: $el,
        es: options.elastic || elastic,
        getAppState: options.getAppState || function () { return {}; }
      });
      $scope.$digest();
    });
  }

  afterEach(function () {
    $el.empty();
  });

  it('basic data fetch', function (done) {
    init({
      params: {
        xFieldName: 'extension',
        yFieldName: 'bytes',
        labelFieldName: '@tags',
        colorFieldName: '@tags',
        dotSizeFieldName: 'bytes',
        aggMode: 'Straight data'
      }
    });
    $scope.loadData().then(function () {
      try {
        expect($scope.data.totalHits).to.be.equal(49487);
        expect($scope.data.data).to.be.an(Array);
        expect($scope.data.data).to.have.length(10);
        expect($scope.data.data[8].x).to.be.equal('php');
        expect($scope.data.data[8].y).to.be.equal(40.141592);
        expect($scope.data.data[8].label).to.be.equal('bat');
        expect($scope.data.data[8].color).to.be.equal('bat');
        expect($scope.data.data[8].size).to.be.equal(40.141592);
        expect($scope.options.xField.type).to.be.equal('string');
        expect($scope.options.yField.type).to.be.equal('number');
        done();
      } catch (e) {
        done(e);
      }
    });
  });

  it('missing xfield', function (done) {
    init({
      params: {
        xFieldName: '',
        yFieldName: 'bytes',
        aggMode: 'Straight data'
      }
    });
    $scope.loadData().then(function () {
      try {
        expect($scope.data.totalHits).to.be.equal(49487);
        expect($scope.data.data).to.be.an(Array);
        expect($scope.data.data).to.have.length(0);
        done();
      } catch (e) {
        done(e);
      }
    });
  });

  it('missing yfield', function (done) {
    init({
      params: {
        xFieldName: 'extension',
        yFieldName: '',
        aggMode: 'Straight data'
      }
    });
    $scope.loadData().then(function () {
      try {
        expect($scope.data.totalHits).to.be.equal(49487);
        expect($scope.data.data).to.be.an(Array);
        expect($scope.data.data).to.have.length(0);
        done();
      } catch (e) {
        done(e);
      }
    });
  });

  it('wrong fields', function (done) {
    init({
      params: {
        xFieldName: 'extension',
        yFieldName: 'bytes',
        labelFieldName: 'missing',
        colorFieldName: 'missing',
        dotSizeFieldName: 'missing',
        aggMode: 'Straight data'
      }
    });
    $scope.loadData().then(function () {
      try {
        expect($scope.data.totalHits).to.be.equal(49487);
        expect($scope.data.data).to.be.an(Array);
        expect($scope.data.data).to.have.length(10);
        expect($scope.data.data[8].label).to.be.equal(null);
        expect($scope.data.data[8].color).to.be.equal(null);
        expect($scope.data.data[8].size).to.be.equal(null);
        done();
      } catch (e) {
        done(e);
      }
    });
  });

  it('date', function (done) {
    init({
      params: {
        xFieldName: '@timestamp',
        yFieldName: 'bytes',
        aggMode: 'Straight data'
      }
    });
    $scope.loadData().then(function () {
      try {
        expect($scope.data.totalHits).to.be.equal(49487);
        expect($scope.data.data).to.be.an(Array);
        expect($scope.data.data).to.have.length(10);
        expect(moment($scope.data.data[8].x).format('YYYYMMDD')).to.be('20101020');
        expect($scope.data.data[8].y).to.be.equal(40.141592);
        done();
      } catch (e) {
        done(e);
      }
    });
  });



});
