import ngMock from 'ng_mock';
import angular from 'angular';
import { stubbedLogstashIndexPatternService } from 'fixtures/stubbed_logstash_index_pattern';
import expect from 'expect.js';

describe('scatterplot svg', function () {
  let $parentScope;
  let $scope;
  let $elem;
  let indexPattern;

  beforeEach(ngMock.module('kibana'));

  function init(data, options) {
    ngMock.inject(function ($rootScope, $compile) {
        // Give us a scope
      $parentScope = $rootScope;

      // Create the element
      $elem = angular.element(
        '<scatter-plot data=data options=options></scatter-plot>'
      );

      $parentScope.data = data;
      $parentScope.options = options;

      // And compile it
      $compile($elem)($parentScope);

      // Fire a digest cycle
      $elem.scope().$digest();

      // Grab the isolate scope so we can test it
      $scope = $elem.isolateScope();
    });
  }

  afterEach(function () {
    $elem.empty();
  });

  it('should set the color label as an empty string, when the color is a null', function () {
    const data = {
      data: [
        {
          color: 'z',
          label: 'label',
          size: 540,
          x: '100',
          xJitter: 'USD',
          y: 540,
          _id: 'AWS3dCkAKWOcbxfWI8as'
        },
        {
          color: null,
          label: 'label',
          size: 200,
          x: '200',
          xJitter: 'IRL',
          y: 1000,
          _id: 'AWS3dCkAKWOcbxfWI8gn'
        }]
    };

    ngMock.inject(function (Private) {
      indexPattern = Private(stubbedLogstashIndexPatternService);
    });

    const options = {
      xField: indexPattern.fields[12],
      yField: indexPattern.fields[11],
      xJitterFieldName: '',
      xAxisScale: 'linear',
      yAxisScale: 'log',
      xJitterField: indexPattern.fields[12],
      dotSizeScale: 'linear'
    };
    init(data, options);

    const colorLabels = $elem.find('g.legends > g > text');
    expect(colorLabels[0].innerHTML).to.be('z');
    expect(colorLabels[1].innerHTML).to.be('');
  });

});
