import { RegistryFieldFormatsProvider } from 'ui/registry/field_formats';

function initCommonOptions(options) {
  options.xJitterField = {name: ''};
  options.xJitterFieldName = '';
  options.colorField = {name: ''};
  options.colorFieldName = '';
  options.labelEnabled = true;
  options.labelHoverEnabled = true;
  options.xAxisScale = 'linear';
  options.yAxisScale = 'linear';
}

export function ConfigureOptionsProvider(Private) {
  return function (options) {
    let fieldFormats = Private(RegistryFieldFormatsProvider);

    if (options.aggMode === 'Significant term data') {
      initCommonOptions(options);
      options.xField = {
        name: 'bg_count',
        type: 'float',
        format: fieldFormats.getDefaultInstance('float')
      };
      options.yField = {
        name: 'doc_count',
        type: 'float',
        format: fieldFormats.getDefaultInstance('float')
      };
      options.xFieldName = 'bg_count';
      options.yFieldName = 'doc_count';
      options.labelFieldName = options.stField.type !== 'date' ? 'key' : 'key_as_string';
      options.dotSizeFieldName = 'score';
      options.dotSizeField = {name: 'score'};
      options.labelField = {name: options.stField.type !== 'date' ? 'key' : 'key_as_string'};
    }

    if (options.aggMode === 'Filtered aggregator data') {
      initCommonOptions(options);
      let faFieldType = 'string';
      switch (options.faBucket.name) {
        case 'date_histogram':
          faFieldType = 'date';
          break;
        case 'histogram':
          faFieldType = 'number';
          break;
        case 'terms':
          faFieldType = options.faBucket.field.type;
          break;
        case 'significant_terms':
          faFieldType = options.faBucket.field.type;
          break;
      };

      options.xField = {
        name: options.faFilterX,
        type: 'number',
        format: fieldFormats.getDefaultInstance('number')
      };
      options.yField = {
        name: options.faFilterY,
        type: 'number',
        format: fieldFormats.getDefaultInstance('number')
      };
      options.xFieldName = options.faFilterX;
      options.yFieldName = options.faFilterY;
      options.labelFieldName = faFieldType !== 'date' ? 'key' : 'key_as_string';
      options.dotSizeFieldName = '';
      options.dotSizeField = {name: ''};
      options.labelField = {name: faFieldType !== 'date' ? 'key' : 'key_as_string'};
      options.xAxisLabel = options.faFilterX;
      options.yAxisLabel = options.faFilterY;
    }

    if (options.aggMode === 'Any aggregator data') {
      initCommonOptions(options);
      let aaFieldType = 'string';
      switch (options.aaBucket.name) {
        case 'date_histogram':
          aaFieldType = 'date';
          break;
        case 'histogram':
          aaFieldType = 'number';
          break;
        case 'terms':
          aaFieldType = options.aaBucket.field.type;
          break;
        case 'significant_terms':
          aaFieldType = options.aaBucket.field.type;
          break;
      };

      options.xField = {
        name: options.aaXmetric.name,
        type: 'number',
        format: fieldFormats.getDefaultInstance('number')
      };
      options.yField = {
        name: options.aaYmetric.name,
        type: 'number',
        format: fieldFormats.getDefaultInstance('number')
      };
      options.xFieldName = options.aaXmetric.name;
      options.yFieldName = options.aaYmetric.name;
      options.labelFieldName = aaFieldType !== 'date' ? 'key' : 'key_as_string';
      options.dotSizeFieldName = '';
      options.dotSizeField = {name: ''};
      options.labelField = {name: aaFieldType !== 'date' ? 'key' : 'key_as_string'};
      options.xAxisLabel = options.aaXmetric.name;
      options.yAxisLabel = options.aaYmetric.name;
    }
  };
};