'use strict';

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _utils = require('../utils');

var _command = require('./command');

var _command2 = _interopRequireDefault(_command);

var _serve = require('./serve/serve');

var _serve2 = _interopRequireDefault(_serve);

var _replace_encryption_key = require('./kibi/replace_encryption_key');

var _replace_encryption_key2 = _interopRequireDefault(_replace_encryption_key);

var _upgrade = require('./kibi/upgrade');

var _upgrade2 = _interopRequireDefault(_upgrade);

var _backup = require('./kibi/backup');

var _backup2 = _interopRequireDefault(_backup);

var _restore = require('./kibi/restore');

var _restore2 = _interopRequireDefault(_restore);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// kibi: kibi commands
const argv = process.env.kbnWorkerArgv ? JSON.parse(process.env.kbnWorkerArgv) : process.argv.slice();
const program = new _command2.default('bin/investigate'); // kibi: renamed kibana to investigate

program.version(_utils.pkg.kibi_version).description('Siren Investigate extends Kibana with data intelligence features. ' + 'At the core, Siren Investigate can join and filter data live from multiple indexes (elasticsearch) or from SQL/NOSQL sources. ' + 'Kibana is a trademark of Elasticsearch BV, registered in the U.S. and in other countries.');

// attach commands
(0, _serve2.default)(program);
// kibi: kibi commands
(0, _replace_encryption_key2.default)(program);
(0, _upgrade2.default)(program);
(0, _backup2.default)(program);
(0, _restore2.default)(program);

program.command('help <command>').description('Get the help for a specific command').action(function (cmdName) {
  const cmd = _lodash2.default.find(program.commands, { _name: cmdName });
  if (!cmd) return program.error(`unknown command ${cmdName}`);
  cmd.help();
});

program.command('*', null, { noHelp: true }).action(function (cmd) {
  if (!['test:server', 'jenkins:unit'].includes(cmd)) {
    program.error(`unknown command ${cmd}`);
  }
});

// check for no command name
const subCommand = argv[2] && !String(argv[2][0]).match(/^-|^\.|\//);

if (!subCommand) {
  if (_lodash2.default.intersection(argv.slice(2), ['-h', '--help']).length) {
    program.defaultHelp();
  } else {
    argv.splice(2, 0, ['serve']);
  }
}

program.parse(argv);
