'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.translateToES = translateToES;
async function translateToES(server, req) {
  let translatedQuery;
  const lines = req.payload.toString('utf-8').split(/\n\r?/);
  const filtered = lines.filter(line => line.trim() !== '');
  if (filtered.length > 1) {
    // translate queries
    let translatedMsearch = '';
    for (let i = 0; i < filtered.length; i++) {
      if (i % 2 === 0) {
        // meta
        translatedMsearch += filtered[i] + '\n';
      } else {
        const translatedRow = await server.plugins.query_engine.translateToES(server, req, filtered[i]);
        translatedMsearch += JSON.stringify(translatedRow) + '\n';
      }
    }
    translatedQuery = translatedMsearch;
  } else {
    const translatedRow = await server.plugins.query_engine.translateToES(server, req, filtered[0]);
    translatedQuery = JSON.stringify(translatedRow);
  }

  return translatedQuery;
}
