'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// kibi: imports


var _create_agent = require('./create_agent');

var _create_agent2 = _interopRequireDefault(_create_agent);

var _map_uri = require('./map_uri');

var _map_uri2 = _interopRequireDefault(_map_uri);

var _lodash = require('lodash');

var _util = require('./util');

var _util2 = _interopRequireDefault(_util);

var _siren_join = require('./siren_join');

var _siren_join2 = _interopRequireDefault(_siren_join);

var _dbfilter = require('./dbfilter');

var _dbfilter2 = _interopRequireDefault(_dbfilter);

var _custom_clusters = require('./custom_clusters');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// kibi: end

const createPath = function (prefix, path) {
  path = path[0] === '/' ? path : `/${path}`;
  prefix = prefix[0] === '/' ? prefix : `/${prefix}`;

  return `${prefix}${path}`;
};

module.exports = function createProxy(server, method, path, config) {
  const sirenJoin = (0, _siren_join2.default)(server);
  const serverConfig = server.config();

  const proxies = new Map([['/elasticsearch', server.plugins.elasticsearch.getCluster('data')], ['/es_admin', server.plugins.elasticsearch.getCluster('admin')]]);

  // kibi: add proxies for special clusters
  // add a proxy for connector plugin
  let connectorAdminCluster = 'data';
  // remember "has" will return true if it is defined in the schema !!!  So use get
  if (serverConfig.get(_custom_clusters.CONNECTOR_CLUSTER_PROPERTY)) {
    const clusterName = serverConfig.get(_custom_clusters.CONNECTOR_CLUSTER_PROPERTY);
    const clustersConfig = serverConfig.get(_custom_clusters.CLUSTERS_PROPERTY);
    if (clusterName && clustersConfig && clustersConfig[clusterName]) {
      connectorAdminCluster = clusterName;
    } else {
      server.log(['error', 'elasticsearch'], (0, _custom_clusters.getConfigMismatchErrorMessage)(clusterName, _custom_clusters.CONNECTOR_CLUSTER_PROPERTY));
    }
  }
  proxies.set('/connector_elasticsearch', server.plugins.elasticsearch.getCluster(connectorAdminCluster));

  // add a proxy for siren alert plugin
  let alertAdminCluster = 'data';
  // remember "has" will return true if it is defined in the schema !!!  So use get
  if (serverConfig.get(_custom_clusters.ALERT_CLUSTER_PROPERTY)) {
    const clusterName = serverConfig.get(_custom_clusters.ALERT_CLUSTER_PROPERTY);
    const clustersConfig = serverConfig.get(_custom_clusters.CLUSTERS_PROPERTY);
    if (clusterName && clustersConfig && clustersConfig[clusterName]) {
      alertAdminCluster = clusterName;
    } else {
      server.log(['error', 'elasticsearch'], (0, _custom_clusters.getConfigMismatchErrorMessage)(clusterName, _custom_clusters.ALERT_CLUSTER_PROPERTY));
    }
  }
  proxies.set('/alert_elasticsearch', server.plugins.elasticsearch.getCluster(connectorAdminCluster));
  // kibi: end

  function getCredentials(request) {
    let credentials = serverConfig.has('xpack.security.cookieName') ? request.state[serverConfig.get('xpack.security.cookieName')] : null;
    if (request.auth && request.auth.credentials && request.auth.credentials.proxyCredentials) {
      credentials = request.auth.credentials.proxyCredentials;
    }
    return credentials;
  }

  /**
   * Sends the proxied response to the client.
   *
   * @param reply - reply interface
   * @param buffer - data buffer
   * @param upstream - the upstream response
   * @param ttl - The upstream ttl as returned by h2o2.
   */
  function sendResponse(reply, buffer, upstream, ttl) {
    if (upstream.headers.location) {
      // TODO: Workaround for #8705 until hapi has been updated to >= 15.0.0
      upstream.headers.location = encodeURI(upstream.headers.location);
    }

    reply(buffer).code(upstream.statusCode).ttl(ttl).headers = upstream.headers;
  }

  const handler = {
    kibi_proxy: {
      onBeforeSendRequest: request => {
        const req = request.raw.req;

        return new Promise((resolve, reject) => {
          const chunks = [];
          req.on('error', reject);
          req.on('data', chunk => chunks.push(chunk));
          req.on('end', () => {
            const inputBuffer = Buffer.concat(chunks);
            if (serverConfig.get('logging.verbose')) {
              server.log(['debug', 'kibi_proxy', 'raw Siren Investigate query'], `\n-------------------------\n${req.url}\n${inputBuffer.toString()}\n-------------------------`);
            }
            let outputBuffer;
            if (
            // NOTE:
            // We use the magic bytes for gzip compressed file 0x1f 0x8b 0x08
            // We can not rely only on the 'content-encoding' header as in some case the proxy server
            // might decompress the request on the fly, but will leave the header intact
            inputBuffer[0] === 0x1f && inputBuffer[1] === 0x8b && inputBuffer[2] === 0x08 && request.headers['content-encoding'] === 'gzip' && server.plugins.clientside_compression && server.plugins.clientside_compression.decodeGzipCompressedBuffer) {
              outputBuffer = server.plugins.clientside_compression.decodeGzipCompressedBuffer(inputBuffer);
              if (serverConfig.get('logging.verbose')) {
                server.log(['debug', 'kibi_proxy', 'detected gzip compressed request, decompressed to'], `\n-------------------------\n${req.url}\n${outputBuffer.toString()}\n-------------------------`);
              }
            } else {
              outputBuffer = inputBuffer;
            }

            if (req.url === '/es_admin/_siren/license') {
              return resolve(_extends({
                payload: outputBuffer
              }, server.plugins.saved_objects_api.getServerCredentials()));
            } else if (/^\/elasticsearch\/_siren\/job\/.*\/_cancel$/.test(req.url)) {
              return resolve(_extends({}, server.plugins.saved_objects_api.getServerCredentials()));
            } else {
              /* Manipulate a set of queries, at the end of which the resulting queries
              * must be concatenated back into a Buffer. The queries in the body are
              * separated by a newline.
              */

              _util2.default.getQueriesAsPromise(outputBuffer).map(query => (0, _dbfilter2.default)(server.plugins.query_engine.getQueryEngine(), query, getCredentials(request))).map(query => sirenJoin.set(query)).map(query => sirenJoin.sequence(query)).then(data => {
                const buffers = (0, _lodash.map)(data, query => Buffer.from(JSON.stringify(query) + '\n'));

                // prevent the string to be created
                if (serverConfig.get('logging.verbose')) {
                  server.log(['debug', 'kibi_proxy', 'translated elasticsearch query'], '\n-------------------------\n' + Buffer.concat(buffers).toString() + '\n' + '-------------------------');
                }

                resolve({ payload: Buffer.concat(buffers) });
              }).catch(err => {
                let errStr;
                if (typeof err === 'object' && err.stack) {
                  errStr = err.toString();
                } else {
                  errStr = JSON.stringify(err, null, ' ');
                }
                server.log(['error', 'create_kibi_proxy'], 'Something went wrong while modifying request: ' + errStr);
                reject(err);
              });
            }
          });
        });
      },
      onResponse: (err, response, request, reply, settings, ttl) => {
        if (err) {
          reply(err);
          return;
        }

        const chunks = [];

        if (response === null || response === undefined) {
          server.log(['error', 'create_kibi_proxy'], 'Something went wrong response is: ' + response);
          return;
        }

        response.on('error', error => reply(error));
        response.on('data', chunk => chunks.push(chunk));
        response.on('end', () => sendResponse(reply, Buffer.concat(chunks), response, ttl));
      }
    }
  };

  for (const [proxyPrefix, cluster] of proxies) {
    const options = {
      method,
      path: createPath(proxyPrefix, path),
      config: {
        timeout: {
          socket: cluster.getRequestTimeout()
        }
      },
      handler
    };

    (0, _lodash.assign)(options.config, config);
    (0, _lodash.assign)(options.handler.kibi_proxy, {
      mapUri: (0, _map_uri2.default)(cluster, proxyPrefix, server, true),
      agent: (0, _create_agent2.default)({
        url: cluster.getUrl(),
        ssl: cluster.getSsl()
      }),
      xforward: true,
      // required to pass through request headers
      timeout: cluster.getRequestTimeout()
    });

    server.route(options);
  }
};
