'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SECURITY_CLUSTER_PROPERTY = exports.ALERT_CLUSTER_PROPERTY = exports.CONNECTOR_CLUSTER_PROPERTY = exports.CLUSTERS_PROPERTY = undefined;
exports.getConfigMismatchErrorMessage = getConfigMismatchErrorMessage;
exports.createCustomClusters = createCustomClusters;

var _lodash = require('lodash');

var _client_logger = require('./client_logger');

const CLUSTERS_PROPERTY = exports.CLUSTERS_PROPERTY = 'elasticsearch.siren.clusters';
const CONNECTOR_CLUSTER_PROPERTY = exports.CONNECTOR_CLUSTER_PROPERTY = 'elasticsearch.siren.connector.admin.cluster';
const ALERT_CLUSTER_PROPERTY = exports.ALERT_CLUSTER_PROPERTY = 'elasticsearch.siren.alert.admin.cluster';
const SECURITY_CLUSTER_PROPERTY = exports.SECURITY_CLUSTER_PROPERTY = 'elasticsearch.siren.security.admin.cluster';

function getConfigMismatchErrorMessage(clusterName, clusterProperty) {
  return 'Could not find configuration for [' + clusterName + '] cluster. ' + 'Check if there is a match between ' + clusterProperty + ' property ' + 'and any cluster configured in elasticsearch.siren.clusters property';
}

function createCustomClusters(server) {
  const config = server.config();
  const ElasticsearchClientLogging = (0, _client_logger.clientLogger)(server);

  function getConfig(config) {
    if (Boolean(config.tribe.url)) {
      return config.tribe;
    }
    return config;
  }

  const clustersConfig = config.get('elasticsearch.siren.clusters');
  (0, _lodash.each)(clustersConfig, (conf, key) => {
    let config = conf;
    if (Boolean(conf.tribe.url)) {
      config = conf.tribe;
    }

    class DataClientLogging extends ElasticsearchClientLogging {
      constructor(...args) {
        var _temp;

        return _temp = super(...args), this.tags = ['cluster:' + key], this.logQueries = config.logQueries, _temp;
      }

    }

    const customCluster = server.plugins.elasticsearch.createCluster(key, Object.assign({ log: DataClientLogging }, config));

    server.on('close', (0, _lodash.bindKey)(customCluster, 'close'));
  });
}
