import { uiModules } from 'ui/modules';
import { VisController } from 'plugins/input_control_vis/vis_controller';
import { getUpdateStatus } from 'plugins/input_control_vis/wrapper/helpers/update_status';
import { InjectAPI } from 'plugins/input_control_vis/wrapper/helpers/inject_api';

uiModules
  .get('kibana/input_control_vis')
  .directive('kbnInputControlVisDirective', function (Private, indexPatterns, timefilter, $compile, $timeout) {

    const injectAPI = new InjectAPI(Private, indexPatterns, timefilter);

    function link($scope, $el) {

      injectAPI.injectAPIs($scope);

      const visualization = new VisController($el[0], $scope.vis);

      const renderVis = () => {
        visualization.render(null, getUpdateStatus($scope));
      };

      renderVis();

      $el.on('$destroy', () => {
        visualization.destroy();
      });

      $scope.$on('fetch', renderVis);

      if (window.location.href.includes('kibana#/visualize/')) { // Alternative to editorMode from 6.x
        let triggerDelay;
        const delayInMs = 100;
        $scope.$watch('vis.params',
          function () {
            $timeout.cancel(triggerDelay);  // Cancel if timeout going on
            triggerDelay = $timeout(function () {
              renderVis();
            },delayInMs);
          }, true);
      }

    };

    return {
      restrict: 'E',
      scope: {
        vis: '='
      },
      link: link
    };
  });