import 'plugins/kibana/dashboard/saved_dashboard/saved_dashboard';
import { uiModules } from 'ui/modules';
import { SavedObjectLoader } from 'ui/courier/saved_object/saved_object_loader';
import { savedObjectManagementRegistry } from 'plugins/kibana/management/saved_object_registry';

// kibi: imports
import { CacheProvider } from 'ui/kibi/helpers/cache_helper';
// kibi: end

const module = uiModules.get('app/dashboard');

// Register this service with the saved object registry so it can be
// edited by the object editor.
savedObjectManagementRegistry.register({
  service: 'savedDashboards',
  title: 'dashboards'
});

// This is the only thing that gets injected into controllers
// kibi: added Private
module.service('savedDashboards', function (SavedDashboard, kbnIndex, kbnUrl, Private, $http) {
  const options = {
    caching: {
      find: true,
      cache: Private(CacheProvider)
    },
    $http
  };
  return new SavedObjectLoader(SavedDashboard, kbnIndex, kbnUrl, options);
});
