import _ from 'lodash';
import 'ui/notify';
import { uiModules } from 'ui/modules';


const module = uiModules.get('discover/saved_relations', [
  'kibana/notify',
  'kibana/courier'
]);

module.factory('SavedRelation', function (courier, SavedSearch) {
  _.class(SavedRelation).inherits(courier.SavedObject);
  function SavedRelation(id) {
    courier.SavedObject.call(this, {
      type: SavedRelation.type,
      mapping: SavedRelation.mapping,

      id: id,
      defaults: {
        title: 'New Relation',
        version: 1,
        domainId: '',
        domainField: '',
        rangeId: '',
        rangeField: '',
        directLabel: '',
        inverseLabel: '',
        inverseOf: '',
        timeout: -1,
        joinType: null
      }
    });
  }

  SavedRelation.type = 'relation';


  SavedRelation.mapping = {
    title: 'string',
    version: 'integer',
    domainId: 'string',
    domainField: 'string',
    rangeId: 'string',
    rangeField: 'string',
    directLabel: 'string',
    inverseLabel: 'string',
    inverseOf: 'string',
    timeout: 'integer',
    joinType: 'string'
  };

  SavedRelation.searchSource = true;

  return SavedRelation;
});
