// kibi: removed intervalName and notExpandable as in Kibana 6.0.0
export function sendCreateIndexPatternRequest(
  indexPatterns, {
    id,
    name,
    timeFieldName,
    excludeIndices, // kibi: added excludeIndices
  },
  skipOverwrite = false // kibi: added option skipOverwrite
) {
  // get an empty indexPattern to start
  return indexPatterns.get()
    .then(indexPattern => {
      Object.assign(indexPattern, {
        id,
        title: name,
        timeFieldName,
        excludeIndices // kibi: added excludeIndices
      });

      // fetch the fields
      return indexPattern.create(skipOverwrite);
    });
}
