'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerFieldCapabilities = registerFieldCapabilities;

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _handle_es_error = require('../../../lib/handle_es_error');

var _handle_es_error2 = _interopRequireDefault(_handle_es_error);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function registerFieldCapabilities(server) {
  server.route({
    path: '/api/kibana/{indices}/field_capabilities',
    method: ['GET'],
    handler: function (req, reply) {
      const { callWithRequest } = server.plugins.elasticsearch.getCluster('data');
      const indices = req.params.indices || '';

      // kibi: use field_caps instead of field_stats
      return callWithRequest(req, 'fieldCaps', {
        fields: '*',
        index: indices,
        allowNoIndices: false
      }).then(res => {
        const fields = _lodash2.default.get(res, 'fields', {});
        const fieldsFilteredValues = _lodash2.default.mapValues(fields, value => {
          const capabilities = {
            searchable: false,
            aggregatable: false
          };
          _lodash2.default.each(value, (caps, type) => {
            if (caps.searchable) {
              capabilities.searchable = true;
            }
            if (caps.aggregatable) {
              capabilities.aggregatable = true;
            }
          });
          return capabilities;
        });

        const retVal = { fields: fieldsFilteredValues };
        if (res._shards && res._shards.failed) {
          retVal.shard_failure_response = res;
        }

        reply(retVal);
      }, error => {
        reply((0, _handle_es_error2.default)(error));
      });
      // kibi: end
    }
  });
}
