'use strict';

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _process_function_definition = require('./server/lib/process_function_definition');

var _process_function_definition2 = _interopRequireDefault(_process_function_definition);

var _timelionSheet = require('./server/lib/saved_objects/timelion-sheet');

var _timelionSheet2 = _interopRequireDefault(_timelionSheet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

module.exports = function (server) {
  server.plugins.saved_objects_api.registerType(_timelionSheet2.default);

  require('./server/routes/run.js')(server);
  require('./server/routes/functions.js')(server);
  require('./server/routes/validate_es.js')(server);

  const functions = require('./server/lib/load_functions')('series_functions');

  function addFunction(func) {
    _lodash2.default.assign(functions, (0, _process_function_definition2.default)(func));
  }

  function getFunction(name) {
    if (!functions[name]) throw new Error('No such function: ' + name);
    return functions[name];
  }

  server.plugins.timelion = {
    functions: functions,
    addFunction: addFunction,
    getFunction: getFunction
  };
};
// kibi: register timelion-sheets with the saved_objects_api plugin
