'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _lazy_server = require('./lazy_server');

var _lazy_server2 = _interopRequireDefault(_lazy_server);

var _lazy_optimizer = require('./lazy_optimizer');

var _lazy_optimizer2 = _interopRequireDefault(_lazy_optimizer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = async (kbnServer, kibanaHapiServer, config) => {
  const server = new _lazy_server2.default(config.get('optimize.lazyHost'), config.get('optimize.lazyPort'), config.get('server.basePath'), new _lazy_optimizer2.default({
    log: (tags, data) => kibanaHapiServer.log(tags, data),
    env: kbnServer.bundles.env,
    bundles: kbnServer.bundles,
    profile: config.get('optimize.profile'),
    sourceMaps: config.get('optimize.sourceMaps'),
    prebuild: config.get('optimize.lazyPrebuild'),
    unsafeCache: config.get('optimize.unsafeCache')
  }));

  let ready = false;

  const sendReady = () => {
    if (!process.connected) return;
    process.send(['WORKER_BROADCAST', { optimizeReady: ready }]);
  };

  process.on('message', msg => {
    if (msg && msg.optimizeReady === '?') sendReady();
  });

  sendReady();

  await server.init();

  ready = true;
  sendReady();
};

module.exports = exports['default'];
