'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.contentTypesProvider = contentTypesProvider;

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _string = require('../../ui/public/utils/lodash-mixins/string');

var _highlight_html = require('./helpers/highlight/highlight_html');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _string.lodashStringMixin)(_lodash2.default);

function contentTypesProvider() {

  const types = {
    html: function (format, convert) {
      function recurse(value, field, hit, meta) {
        if (value == null) {
          return _lodash2.default.asPrettyString(value);
        }

        if (!value || typeof value.map !== 'function') {
          return convert.call(format, value, field, hit, meta);
        }

        const subVals = value.map(v => recurse(v, field, hit, meta));
        const useMultiLine = subVals.some(sub => sub.includes('\n'));

        return subVals.join(',' + (useMultiLine ? '\n' : ' '));
      }

      return (...args) => `<span ng-non-bindable>${recurse(...args)}</span>`;
    },

    text: function (format, convert) {
      function recurse(value, field, hit, meta) {
        if (!value || typeof value.map !== 'function') {
          return convert.call(format, value, field, hit, meta);
        }

        const subVals = value.map(v => recurse(v, field, hit, meta));
        const useMultiLine = subVals.some(sub => sub.includes('\n'));

        return subVals.join(',' + (useMultiLine ? '\n' : ' '));
      }

      return (...args) => recurse(...args);
    }
  };

  function fallbackText(value) {
    return _lodash2.default.asPrettyString(value);
  }

  function fallbackHtml(value, field, hit) {
    const formatted = _lodash2.default.escape(this.convert(value, 'text'));

    if (!hit || !hit.highlight || !hit.highlight[field.name]) {
      return formatted;
    } else {
      return (0, _highlight_html.getHighlightHtml)(formatted, hit.highlight[field.name]);
    }
  }

  function setup(format) {
    const src = format._convert || {};
    const converters = format._convert = {};

    converters.text = types.text(format, src.text || fallbackText);
    converters.html = types.html(format, src.html || fallbackHtml);

    return format._convert;
  }

  return {
    types: types,
    setup: setup
  };
}
