'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.numeralProvider = numeralProvider;

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _numeral = require('@elastic/numeral');

var _numeral2 = _interopRequireDefault(_numeral);

var _field_format = require('./field_format');

var _fetch_config_defaults = require('./fetch_config_defaults');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function numeralProvider(config) {
  const fetchDefaults = param => (0, _fetch_config_defaults.fetchConfigDefaults)(param, config);

  class Numeral extends _field_format.FieldFormat {
    constructor(params) {
      super(params);
    }

    _convert(val) {
      if (val === -Infinity) return '-∞';
      if (val === +Infinity) return '+∞';
      if (typeof val !== 'number') {
        val = parseFloat(val);
      }

      if (isNaN(val)) return '';

      return (0, _numeral2.default)(val).format(this.param('pattern'));
    }

    static factory(opts) {
      class Class extends Numeral {
        constructor(params) {
          super(params);
        }
      }

      Class.id = opts.id;
      Class.title = opts.title;
      Class.fieldType = 'number';
      Class.paramDefaults = opts.paramDefaults || fetchDefaults({
        pattern: '=format:' + opts.id + ':defaultPattern'
      });

      if (opts.prototype) {
        _lodash2.default.assign(Class.prototype, opts.prototype);
      }

      return Class;
    }
  }

  return Numeral;
}
