'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dateProvider = dateProvider;

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

var _field_format = require('./field_format');

var _fetch_config_defaults = require('./fetch_config_defaults');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function dateProvider(config) {
  const fetchDefaults = param => (0, _fetch_config_defaults.fetchConfigDefaults)(param, config);
  class DateTime extends _field_format.FieldFormat {
    constructor(params) {
      super(params);
    }

    // kibi: mapping was added to make correct label for date fields with custom mapping
    _convert(val, mapping) {
      // don't give away our ref to converter so
      // we can hot-swap when config changes
      const pattern = this.param('pattern');
      const timezone = this.param('timezone');

      /* kibi: condition for taking saved values was removed for correct making of labels
        with same user input but different field's mapping */
      this._timeZone = timezone;
      this._memoizedPattern = pattern;

      this._memoizedConverter = _lodash2.default.memoize(function converter(val) {
        if (val === null || val === undefined) {
          return '-';
        }

        // kibi: added condition to correctly build label for fields with epoch_millis and custom mappings
        const FOUR_YEAR_PATTERN_LENGTH = 4;
        let date;
        if (typeof mapping === 'string') {
          const formats = mapping.split('||').map(rule => {
            let ruleToReturn = rule;
            if (rule[0] === ' ') ruleToReturn = ruleToReturn.slice(1);
            if (rule.slice(-1) === ' ') ruleToReturn = ruleToReturn.slice(0, -1);
            return ruleToReturn;
          });

          // noSingleCodeRule - rule to understand if we have mapping with only year format in custom mappings
          // and prevent making label with epoch_millis formatting
          const noSingleCodeRule = ['yy', 'yyyy', 'YY', 'YYYY'].every(code => formats.indexOf(code) === -1);

          // millisRule1 and millisRule1 - rules to understand if field with support of epoch_millis
          const millisRule1 = formats.indexOf('epoch_millis') > 0 && formats.length > 1 && !isNaN(val) && noSingleCodeRule;
          const millisRule2 = formats.indexOf('epoch_millis') === 0 && !isNaN(val);

          if (millisRule1 || millisRule2) {
            date = (0, _moment2.default)(parseInt(val));
            return date.isValid() ? date.format(pattern) : val;
          } else if (!noSingleCodeRule && !isNaN(val)) {
            if (formats.indexOf('epoch_millis') !== -1) {
              date = val.length === FOUR_YEAR_PATTERN_LENGTH ? (0, _moment2.default)(val) : (0, _moment2.default)(parseInt(val));
            } else {
              date = (0, _moment2.default)(val);
            }
            return date.isValid() ? date.format(pattern) : val;
          } else {
            // kibana doesn't understand very customed formats and can't format it by date.format() below
            // better to show in this case raw value
            return val;
          }
        } else {
          date = (0, _moment2.default)(val);
        };

        //if valid date AND (a number OR date object), format the date accordingly
        //toDateString here checks that the date portion of a Date object is in human readable form
        if (date.isValid() && (isNaN(val) || val.toDateString)) {
          return date.format(pattern);
          //Siren's validation 2nd condition can be just epoch_millis or year or infinity
          //and we can correclty format it
        } else if (!isNaN(val)) {
          if (val.length === FOUR_YEAR_PATTERN_LENGTH) {
            return (0, _moment2.default)(val).format(pattern);
          } else {
            return date.isValid() ? (0, _moment2.default)(parseInt(val)).format(pattern) : val;
          };
        } else {
          //Otherwise return val as default
          return val;
        }
        // kibi: end
      });

      return this._memoizedConverter(val);
    }
  }

  DateTime.id = 'date';
  DateTime.title = 'Date';
  DateTime.fieldType = 'date';
  DateTime.paramDefaults = fetchDefaults({
    pattern: '=dateFormat',
    timezone: '=dateFormat:tz'
  });

  return DateTime;
}
