'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (kbnServer, server) {
  registerPlugins(server);
};

var _vision = require('vision');

var _vision2 = _interopRequireDefault(_vision);

var _inert = require('inert');

var _inert2 = _interopRequireDefault(_inert);

var _h2o = require('h2o2');

var _h2o2 = _interopRequireDefault(_h2o);

var _kibiH2o = require('kibi-h2o2');

var _kibiH2o2 = _interopRequireDefault(_kibiH2o);

var _bluebird = require('bluebird');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const plugins = [_vision2.default, _inert2.default, _kibiH2o2.default, _h2o2.default]; // kibi: use the kibi proxy


async function registerPlugins(server) {
  await (0, _bluebird.fromNode)(cb => {
    server.register(plugins, cb);
  });
}

module.exports = exports['default'];
