'use strict';

var _plugin_init = require('./plugin_init');

var _plugin_init2 = _interopRequireDefault(_plugin_init);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

module.exports = async function (kbnServer, server, config) {

  if (!config.get('plugins.initialize')) {
    server.log(['info'], 'Plugin initialization disabled.');
    return [];
  }

  const { plugins } = kbnServer;

  // extend plugin apis with additional context
  plugins.getPluginApis().forEach(api => {

    Object.defineProperty(api, 'uiExports', {
      value: kbnServer.uiExports
    });
  });

  await (0, _plugin_init2.default)(plugins, kbnServer.config);
};
