'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
/**
 * API compatibility description:
 * {
 *  min_es: '6.5.4',// Anything over this version is allowed
 *  min_federate: '6.5.4-10.2.0',
 *  max_federate: ‘7.0.0-10.4.0’,// Backend equating to or higher than this version is NOT allowed
 *  max_es: '7.0.0',
 *  supported_federate_exceptions: [ ‘5.6.10-10.1.1’, ‘6.3.2-10.1.1’],// Exceptions, should be used sparingly. Versions should match exactly
 *  supported_es_exceptions: ['5.6.10', '6.3.2']
 * }
 */
const API_COMPATIBILITY_MATRIX = Object.freeze({
  INGESTION_LIST_API_V2: {
    min_federate: '6.5.4-10.3.0'
  },
  LICENSE_API_V2: {
    min_federate: '6.5.4-10.2.0'
  },
  DATASOURCE_TYPES_API_V1: {
    min_federate: '6.5.4-10.2.0'
  },
  CANCEL_JOB_API_V1: {
    min_federate: '6.3.2-10.1.1'
  },
  SESSION_API_V1: {
    min_federate: '6.5.4-10.2.0'
  }
});

exports.default = API_COMPATIBILITY_MATRIX;
module.exports = exports['default'];
