'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _compatibility = require('./compatibility');

var _module_compatibility_service = require('./module_compatibility_service');

var _module_compatibility_service2 = _interopRequireDefault(_module_compatibility_service);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class FeatureCompatibilityService {
  /**
   * @param  {FederateVersionParser} federateVersion
   */
  constructor(federateVersion) {
    this._compatibilityService = new _module_compatibility_service2.default(federateVersion, _compatibility.FEATURE_COMPATIBILITY_MATRIX);
  }

  /**
   * Check if feature is available
   * @return {Boolean} True if feature is available, otherwise False in case of unknown or disabled features
   */
  isAvailable(featureKey) {
    return this._compatibilityService.isAvailable(featureKey);
  }

  /**
   * @return {[{ key, object }]} Returns a list of { key, object } of disabled features
   */
  getDisabledFeatureList() {
    return this._compatibilityService.getDisabledModuleList();
  }
}exports.default = FeatureCompatibilityService;
;
module.exports = exports['default'];
