'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _federate_version_parser = require('./utils/federate_version_parser');

var _compatibility_status = require('./utils/compatibility_status');

var _compatibility_status2 = _interopRequireDefault(_compatibility_status);

var _errors = require('./utils/errors');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class NodeCompatibilityResolver {

  static resolveCompatibilityStatus(nodeVersion, COMPATIBILITY_MATRIX) {
    const minSupportedCheck = COMPATIBILITY_MATRIX.MIN_SUPPORTED.compareWith(nodeVersion);
    if (minSupportedCheck >= 0) {
      const featureCompleteCheck = COMPATIBILITY_MATRIX.FEATURE_COMPLETE.compareWith(nodeVersion);
      if (featureCompleteCheck >= 0) {
        const targetVersionCheck = COMPATIBILITY_MATRIX.TARGET.compareWith(nodeVersion);
        if (targetVersionCheck > 0) {
          return COMPATIBILITY_MATRIX.TARGET.compareMajorVersion(nodeVersion) ? _compatibility_status2.default.TOO_HIGH : _compatibility_status2.default.TARGET;
        }
        return targetVersionCheck === 0 ? _compatibility_status2.default.TARGET : _compatibility_status2.default.FEATURE_COMPLETE;
      }
      return _compatibility_status2.default.MIN_SUPPORTED;
    }
    return _compatibility_status2.default.TOO_OLD;
  }

  constructor(nodeFederateVersion, compatibilityMatrix) {
    if (nodeFederateVersion) {
      this.rawNodeFederateVersion = nodeFederateVersion;
      try {
        this.nodeFederateVersion = new _federate_version_parser.FederateVersionParser(nodeFederateVersion);
        this.compatibilityStatus = NodeCompatibilityResolver.resolveCompatibilityStatus(this.nodeFederateVersion, compatibilityMatrix);
      } catch (e) {
        if (e.constructor.name === _errors.InvalidVersionError.name) {
          this.compatibilityStatus = _compatibility_status2.default.INVALID_VERSION;
        } else {
          throw e;
        }
      }
    } else {
      this.compatibilityStatus = _compatibility_status2.default.FEDERATE_NOT_FOUND;
    }
  }

  getCompatibilityStatus() {
    return this.compatibilityStatus;
  }

  isCompatible() {
    return this.compatibilityStatus >= _compatibility_status2.default.MIN_SUPPORTED;
  }
}
exports.default = NodeCompatibilityResolver;
module.exports = exports['default'];
