'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
const isValidTests = [{
  input: '6.5.1-10.1.1',
  expected: true
}, {
  input: '6.5.1+10.1.1',
  expected: false
}, {
  input: '10.1.1',
  expected: false
}, {
  input: '10.1.1-6.5.1',
  expected: true
}, {
  input: '6.5.1-10.1',
  expected: false
}, {
  input: '6.5-10.1.1',
  expected: false
}, {
  input: '6.5.1-10.1.1.1',
  expected: false
}, {
  input: '6.5.1-10.1.1-',
  expected: true
}, {
  input: '6.5.1-10.1.1-2',
  expected: true
}, {
  input: '6.5-10.1.1-',
  expected: false
}, {
  input: '6.5.1-10.1.1-CUSTOMER_BUILD-SNAPSHOT',
  expected: true
}, {
  input: '6.5.1-10.1.1-SNAPSHOT',
  expected: true
}];

const retrieveElasticsearchAndFederateVersionsTests = [{
  input: '6.5.1-10.1.1',
  expected: {
    ES: '6.5.1',
    Federate: '10.1.1'
  }
}, {
  input: '10.1.1-6.5.1',
  expected: {
    Federate: '6.5.1',
    ES: '10.1.1'
  }
}];

const compareWithTests = [{
  input: ['5.6.10-10.1.1', '5.6.10-10.1.2'],
  expected: 1
}, {
  input: ['5.6.10-10.1.1', '5.6.9-10.1.2'],
  expected: -1
}, {
  input: ['5.6.10-10.1.1', '5.6.10-10.1.1'],
  expected: 0
}, {
  input: ['6.3.2-10.2.2', '6.5.4-10.2.1'],
  expected: -1
}, {
  input: ['7.0.0-10.3.0', '7.0.1-10.3.0'],
  expected: 1
}, {
  input: ['10.1.1-5.6.10', '5.6.10-10.1.1'],
  expected: -1
}, {
  input: ['5.6.10-10.1.1', '5.6.11-10.1.2'],
  expected: 1
}];
exports.isValidTests = isValidTests;
exports.retrieveElasticsearchAndFederateVersionsTests = retrieveElasticsearchAndFederateVersionsTests;
exports.compareWithTests = compareWithTests;
