import { uiModules } from 'ui/modules';
import chrome from 'ui/chrome';
import {
  FederateResolver
} from '../../../common';

const FEDERATE_COMPATIBILITY = chrome.getInjected('federateCompatibilityMatrix');

uiModules.get('federate_resolver/core/services').service('federateResolver', function (elasticsearchPlugins) {

  if (elasticsearchPlugins.get() === undefined || elasticsearchPlugins.get() === null) {
    throw new Error('Angular Service \'elasticsearchPlugins\' seems to be uninitialized, make sure it\'s being initialized in ' +
      'addSetupWork. If you\'re not using uiRouter in the component, consider a fix like: https://github.com/sirensolutions/ingest/pull/71' +
      ' to initialize it before usage.');
  }
  const federateResolver = new FederateResolver(elasticsearchPlugins.get({ version: true }), FEDERATE_COMPATIBILITY);

  return federateResolver;
});