'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.writeConfigInFormat5 = writeConfigInFormat5;
exports.writeConfigInFormat6 = writeConfigInFormat6;
exports.getConfigStatus = getConfigStatus;
function writeConfigInFormat5(client, logger, index) {
  return client.index({
    index,
    type: 'config',
    id: 'siren',
    refresh: true,
    body: {}
  }).then(res => {
    logger.info('Created empty config object - format version 5');
  });
}

function writeConfigInFormat6(client, logger, index) {
  return client.index({
    index,
    type: 'doc',
    id: 'config:siren',
    refresh: true,
    body: {
      type: 'config',
      config: {}
    }
  }).then(res => {
    logger.info('Created empty config object - format version 6');
  });
}

function successHandler(logger, message, documentFormat, exists) {
  logger.info(message);
  return { exists, documentFormat };
}

function errorHandler(logger, error) {
  logger.error('Was not able to determine document format', error);
  return {
    exists: false,
    documentFormat: undefined
  };
}

function getConfigStatus(client, logger, index) {
  return client.get({
    index,
    type: 'config',
    id: 'siren'
  }).then(format5Response => {
    // do nothing more about the config
    return successHandler(logger, 'Detected document format version 5 based on existing config object', 5, true);
  }).catch(format5Error => {

    if (format5Error.status === 404) {
      // no config in 5 format , lets check in 6 format
      return client.get({
        index,
        type: 'doc',
        id: 'config:siren'
      }).then(format6Response => {
        // do nothing more about the config
        return successHandler(logger, 'Detected document format version 6 based on existing config object', 6, true);
      }).catch(format6Error => {
        if (format6Error.status === 404) {
          // lets examine all other objects lets try to get 1 document
          return client.search({
            index,
            body: {
              query: {
                match_all: {}
              }
            },
            size: 1
          }).then(otherDocumentResponse => {
            if (otherDocumentResponse.hits.total === 0) {
              return successHandler(logger, 'Detected document format version 6 based on empty index', 6, false);
            } else {
              // try to determine document format from objects
              const doc = otherDocumentResponse.hits.hits[0];
              if (doc._type === 'doc') {
                return successHandler(logger, `Detected document format version 6 based on a document id: ${doc._id}`, 6, false);
              } else {
                return successHandler(logger, `Detected document format version 5 based on a document id: ${doc._id}`, 5, false);
              }
            }
          }).catch(otherDocumetError => {
            return errorHandler(logger, otherDocumetError);
          });
        } else {
          return errorHandler(logger, format6Error);
        }
      });
    } else {
      return errorHandler(logger, format5Error);
    }
  });
}
