'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.compareTriples = compareTriples;
exports.findTripleBy = findTripleBy;
exports.removeTriple = removeTriple;

var _lodash = require('lodash');

function compareTriples(expected, actual) {
  // find expected triples which were missing
  const missing = [];
  for (let i = 0; i < expected.length; i++) {
    const expectedTriple = expected[i];
    const found = (0, _lodash.find)(actual, t => {
      return t.s === expectedTriple.s && t.p === expectedTriple.p && t.o === expectedTriple.o;
    });
    if (!found) {
      missing.push(expectedTriple);
    }
  }

  // now find non expected extra triples
  const extra = [];
  for (let i = 0; i < actual.length; i++) {
    const actualTriple = actual[i];
    const found = (0, _lodash.find)(expected, t => {
      return t.s === actualTriple.s && t.p === actualTriple.p && t.o === actualTriple.o;
    });
    if (!found) {
      extra.push(actualTriple);
    }
  }
  if (missing.length > 0) {
    console.log('Missing expected triples: ' + missing.length);
    (0, _lodash.each)(missing, t => {
      console.log(t);
    });
  }
  if (extra.length > 0) {
    console.log('Extra not expected triples: ' + extra.length);
    (0, _lodash.each)(extra, t => {
      console.log(t);
    });
  }
  if (missing.length > 0 || extra.length > 0) {
    return false;
  }
  return true;
};

function findTripleBy(triples, s, p, o) {
  return (0, _lodash.filter)(triples, t => {
    if (s && p && o) {
      return t.s === s && t.p === p && t.o === o;
    }
    if (s && p) {
      return t.s === s && t.p === p;
    }
    if (p && o) {
      return t.p === p && t.o === o;
    }
    if (s && o) {
      return t.s === s && t.o === o;
    }
    if (s) {
      return t.s === s;
    }
    if (p) {
      return t.p === p;
    }
    if (o) {
      return t.o === o;
    }
    return false;
  });
}

function removeTriple(triples, tripleToRemove) {
  (0, _lodash.remove)(triples, function (t) {
    return tripleToRemove.s === t.s && tripleToRemove.p === t.p && tripleToRemove.o === t.o;
  });
}
