import { management } from 'ui/management';
import { SavedObjectRegistryProvider } from 'ui/saved_objects/saved_object_registry';
import savedScriptsRegister from './services/saved_scripts_register';
import './controllers/scripts_editor';
import { uiModules } from 'ui/modules';

uiModules.get('apps/settings', ['ui.ace', 'monospaced.elastic']);

SavedObjectRegistryProvider.register(savedScriptsRegister);

management
  .getSection('kibana')
  .register('scripts', {
    display: 'Scripts',
    order: 13,
    url: '#/management/siren/scripts'
  });
